local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local detectdefined = require "videodecet.defined"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local videodecet = require "videodecet"
local Object = require "classic"
local soundcontrol = require "lightgame.manipulatepartical.soundcontrol"
local define = require "lightgame.manipulatepartical.defined"

local manipulatebase = Object:extend();

local soundCtrl = nil;

local function LinearCallback(offset,key_value)  --线性插值
  local len = #key_value;
  local low = 1;
  local high = len;
  local middle = 1;

  while low <= high do
    middle = math.floor((low + high) / 2);
    local pointoffset = key_value[middle][1];
    if pointoffset > offset then
      high = middle - 1;
    elseif pointoffset < offset then
      low = middle + 1;
    else
      return key_value[middle][2];
    end
  end
  
  if key_value[middle][1] > offset then
    middle = middle - 1;
  end
  local first = middle;
  local second = middle + 1;
  if second > len then
    return key_value[len][2];
  end
  if first < 0 then
    return key_value[1][2];
  end
  local offsetFirst = key_value[first][1];
  local offsetSecond = key_value[second][1];
  local pointFirst = key_value[first][2];
  local pointSecond = key_value[second][2];
  --线性插值
  return pointFirst + (pointSecond - pointFirst) * ((offset - offsetFirst) / (offsetSecond - offsetFirst));
end

function manipulatebase:new(trigger,soundA,soundB)
  videodecet:ActiveActions({trigger});  
  self.timemul = 1;
  self.trigger = trigger;
  self.zoom = {1,1,1};
  self.range = {1,1,1};
  self.globaloffset = {0,0,0};
  self.globaloffsetvector = mathfunction.vector3();
  self.globalscalevector = mathfunction.vector3(1.0,1.0,1.0);
  
  --音乐控制粒子
  self.TriggerdCallbackIndex = 1;
  self.TriggerdCallback = {};
  self.UnTriggerdCallbackIndex = 1;
  self.UnTriggerdCallback = {};
  self.OffsetXCallback = nil;
  self.OffsetYCallback = nil;
  self.OffsetZCallback = nil;
  self.ScaleXCallback = nil;
  self.ScaleYCallback = nil;
  self.ScaleZCallback = nil;
  
  self.isDetectPlaying = false;
  self.isSilencePlaying = false;
  
  soundCtrl = soundCtrl or soundcontrol();
  soundCtrl:Stop();

  soundCtrl:Setup(soundA,soundB);
end

function manipulatebase:SetZoom(zoom)
  self.zoom = zoom;
end

function manipulatebase:SetRange(range)
  self.range = range;
end

local fclamp = math.clamp;
function manipulatebase:Update(def)
  
  if def > 0.067 then
    def = 0.067
  end
  
  local detected, action = videodecet:isAction(self.trigger);
  if detected then
    
    
    --额外控制（比如音乐)
    self:_ResetParameter();
    for _,callbackStru in pairs(self.TriggerdCallback) do
      local paramName = callbackStru[1];
      local key_value = callbackStru[2];
      local func = callbackStru[3];
      if key_value ~= nil and func ~= nil then
        local value = func(soundcontrol.GetVolume(),key_value);
        self:_SetTriggerdParam(paramName,value);
      end
    end

    
    local pos = action:GetCenter();
    local rect = action:GetRect();
    local diangle = math.sqrt((rect[1] - rect[3])^2 + (rect[2] - rect[4])^2);
    if not self.lastpos then
      self.lastpos = pos;
      self.lastdiangle = diangle;
    end
    local zoom = self.zoom;
    local ox = zoom[1] * (pos[1] - self.lastpos[1])
    local oy = zoom[2] * (pos[2] - self.lastpos[2])
    local oz = zoom[3] * (diangle - self.lastdiangle);    
    local range = self.range;
    local go = self.globaloffset;
    local scale = {1,1,1};
    go[1] = fclamp(go[1] + ox, -range[1], range[1]);
    go[2] = fclamp(go[2] + oy, -range[2], range[2]);
    go[3] = fclamp(go[3] + oz, -range[3], range[3]);
    
    local volumeforoffset = soundcontrol.GetVolume();
    if self.OffsetXCallback then
      local func = self.OffsetXCallback[2];
      local key_value = self.OffsetXCallback[1];
      local value = func(volumeforoffset,key_value);
      go[1] = go[1] + value;
    end
    if self.OffsetYCallback then
      local func = self.OffsetYCallback[2];
      local key_value = self.OffsetYCallback[1];
      local value = func(volumeforoffset,key_value);
      go[2] = go[2] + value;
    end
    if self.OffsetZCallback then
      local func = self.OffsetZCallback[2];
      local key_value = self.OffsetZCallback[1];
      local value = func(volumeforoffset,key_value);
      go[3] = go[3] + value;
    end
    self.globaloffsetvector:Set(go[1], go[2], go[3]);
    
    local volumeforscale = soundcontrol.GetVolume();
    if self.ScaleXCallback then
      local func = self.ScaleXCallback[2];
      local key_value = self.ScaleXCallback[1];
      local value = func(volumeforscale,key_value);
      scale[1] = scale[1] * value;
    end
    if self.ScaleYCallback then
      local func = self.ScaleYCallback[2];
      local key_value = self.ScaleYCallback[1];
      local value = func(volumeforscale,key_value);
      scale[2] = scale[2] * value;
    end
    if self.ScaleZCallback then
      local func = self.ScaleZCallback[2];
      local key_value = self.ScaleZCallback[1];
      local value = func(volumeforscale,key_value);
      scale[3] = scale[3] * value;
    end
    self.globalscalevector:Set(scale[1], scale[2], scale[3]);

    self.lastpos = pos;
    self.lastdiangle = diangle;
    self:_OnDetected(def, self.globaloffsetvector,self.globalscalevector);
    if self.callback and self.callback.OnDetected then
      self.callback:OnDetected(def, self.globaloffsetvector);
    end
  else
    
    --额外控制（比如音乐)
    self:_ResetParameter();
    for _,callbackStru in pairs(self.UnTriggerdCallback) do
      local paramName = callbackStru[1];
      local key_value = callbackStru[2];
      local func = callbackStru[3];
      if key_value ~= nil and func ~= nil then
        local value = func(soundcontrol.GetVolume(),key_value);
        self:_SetUnTriggerdParam(paramName,value);
      end
    end
    
    self.lastpos = nil;    
    self:_OnSilence(def);
    if self.callback and self.callback.OnSilence then
      self.callback:OnSilence(def);
    end
  end
end

function manipulatebase:PlaySound(soundtype)
  soundCtrl:Play(soundtype);
end

function manipulatebase:StopSound()
  soundCtrl:Stop();
end

function manipulatebase:GetVolume()
  return soundcontrol.GetVolume();
end


function manipulatebase:RegisterCallback(obj)
  self.callback = obj;
end

function manipulatebase:Exit()
  if soundCtrl ~= nil then
    soundCtrl:Stop();
  end
  soundCtrl = nil;
end

function manipulatebase:RegisterTriggeredCallback(paramname,key_value,func)
  local _func = func;
  if _func == nil then  --默认线性插值
    _func = LinearCallback;
  end

  local callbackStru = {paramname,key_value,_func};
  local index = self.TriggerdCallbackIndex;
  self.TriggerdCallbackIndex = self.TriggerdCallbackIndex + 1;
  self.TriggerdCallback[index] = callbackStru;
end

function manipulatebase:RegisterUnTriggeredCallback(paramname,key_value,func)
  local _func = func;
  if _func == nil then  --默认线性插值
    _func = LinearCallback;
  end

  local callbackStru = {paramname,key_value,_func};
  local index = self.UnTriggerdCallbackIndex;
  self.UnTriggerdCallbackIndex = self.UnTriggerdCallbackIndex + 1;
  self.UnTriggerdCallback[index] = callbackStru;
end

function manipulatebase:RegisterGlobalOffsetCallback(axis,key_value,func)
  local _func = func;
  if _func == nil then  --默认线性插值
    _func = LinearCallback;
  end
  if axis == "X" then
    self.OffsetXCallback = {key_value,_func};
  elseif axis == "Y" then
    self.OffsetYCallback = {key_value,_func};
  elseif axis == "Z" then
    self.OffsetZCallback = {key_value,_func};
  end
end

function manipulatebase:RegisterGlobalScaleCallback(axis,key_value,func)
  local _func = func;
  if _func == nil then  --默认线性插值
    _func = LinearCallback;
  end
  if axis == "X" then
    self.ScaleXCallback = {key_value,_func};
  elseif axis == "Y" then
    self.ScaleYCallback = {key_value,_func};
  elseif axis == "Z" then
    self.ScaleZCallback = {key_value,_func};
  end
end





return manipulatebase;