local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local venusjson = require "venusjson"
local venuscore = require "venuscore"
local apolloDefine = require "apolloutility.defiend"
local renderqueue = require "apolloutility.renderqueue"

local lightgame={};

--增加脚本路径
function lightgame:_AddScriptPath(pathDir)
  
  --local gamepath = venuscore.IFileSystem:PathAssembly("root:lightgame");
  --gamepath = (gamepath.."/?.lua;")..(gamepath.."/?/?.lua;")..(gamepath.."/?/init.lua;");
  --gamepath ="E:/faceDeformationDev/master/algo_video_facecute/lightgame/sticker/..";
  --gamepath = (gamepath.."/?.lua;");
  self.originPackagePath = package.path;
  local gamepath=venuscore.IFileSystem:PathAssembly(pathDir);
  gamepath=gamepath.."/?.lua;";
  package.path =gamepath.. package.path;
end

--删除脚本路径
function lightgame:_RemoveScriptPath()  
  if self.originPackagePath then
    package.path = self.originPackagePath;
  end    
end

function lightgame:Initialize(camera)
  self.maincamera=camera;
end

function lightgame:LoadConfig(path)  
  --local path = "root:lightgame/sticker/sticker.json";
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.lightgame then    

    local physicsconfig = rootconfig.lightgame.physics;
    if physicsconfig~=nil then
        self.gravity = physicsconfig.gravity;
        self.globalscale = physicsconfig.globalscale;
        self.maxstep = physicsconfig.maxstep;
        self.fixedupdatetime = physicsconfig.fixedupdatetime;

      
        local nativescene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
        local physicworld = nativescene:GetPhysicWorld();
        physicworld:SetGlobalScale(self.globalscale);
        physicworld:SetGravity(mathfunction.vector3(self.gravity[1],self.gravity[2],self.gravity[3]));     
    end

    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    pathDir = self:_CheckReplace(pathDir, rootconfig.lightgame.mainscript);
    
    self:_AddScriptPath(pathDir);
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    local filepath = rootdir..rootconfig.lightgame.mainscript;
    local func,errorstr = loadfile(venuscore.IFileSystem:PathAssembly(filepath));
    if not errorstr then
      self.game = func();
      local config={};
      --config.filePrefix="root:lightgame/sticker/game";
      --config.filename= config.filePrefix.."/stickergame.lua";
      config.filename = rootdir..rootconfig.lightgame.mainscript;
      config.filePrefix = string.match(config.filename, "(.+)/[^/]*%.%w+$");
      if rootconfig.lightgame.SoundA then
        config.soundA = rootdir .. rootconfig.lightgame.SoundA;
      end
      if rootconfig.lightgame.SoundB then
        config.soundB = rootdir .. rootconfig.lightgame.SoundB;
      end      
      --config.filePrefix = config.filename.."/../";
      
      --hack: 兼容老粒子素材中对Before的调用
      renderqueue.Before = function(self,render)
        if render then
          LOG("******************************* Hack renderqueue before");
          renderqueue:Queue("Sticker",render:GetHostNode());
        end
      end
      
      self.game:Initialize(self.maincamera, config, rootdir, rootconfig);
      
      renderqueue.Before = nil;
      --self.game:Initialize();
      return true;
    else  
      ERROR(errorstr);
      return false;
    end
   

  end
 
  return true;
end

function lightgame:GetStickerResult()
  if self.game and self.game.GetStickerResult then
    return self.game:GetStickerResult();
  end
  return "";
end

function lightgame:OnRecordStart()
  if self.game and self.game.OnRecordStart then
    self.game:OnRecordStart();
  end
end

function lightgame:OnRecordStop()
  if self.game and self.game.OnRecordStop then
    self.game:OnRecordStop();
  end
end

function lightgame:Update(def)
  if(self.game)
  then
     self.game:Update(def);
     if self.maxstep~=nil and self.fixedupdatetime~=nil then
        local nativescene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
        local physicworld = nativescene:GetPhysicWorld();
        physicworld:Update(def,self.maxstep, self.fixedupdatetime);
     end
  end
end

function lightgame:ReleaseResource()
  if(not self.game)
  then
    return;
  end
  self:_RemoveScriptPath();
  self.game:Exit();
  self.game = nil;
  self.gravity = nil;
  self.globalscale = nil;
  self.maxstep = nil;
  self.fixedupdatetime = nil;
end

function lightgame:_CheckReplace(root, filename)
  if filename == "game/bigmouthgame.lua" then
    local newwRoot = "docs:lightgame/bigmouth";
    return newwRoot;
  end
  return root;
end

return lightgame;