local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local venuscore = require "venuscore"

local facetracking = require "facemesh.facetracking"
local posture = require "facecute.estimates.pnpposture"

local facemesh = {}

function facemesh:Initialize()
end

function facemesh:LoadConfig(path)
  local rootconfig = venusjson.LaodJsonFile(path);
  local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
  local rootdir = pathDir.."/";
  venuscore.IFileSystem:SetResourcePath(rootdir);
  self.tracking = facetracking();
  self.tracking:ParseConfig(rootconfig)
  return true;
end

function facemesh:ReleaseResource()
  if self.tracking then
    self.tracking = nil;
  end
end

function facemesh:GetTrackingData()
  return self.tracking:ReceiveInputDatas(); 
end

function facemesh:Positioning()
  local transform = self.tracking:GetTranslation()
  local rotation = self.tracking:GetRotation()
  if transform ~= nil and rotation ~= nil then
    --LOG("[Trans]: " .. transform:x() .. ", " .. transform:y() .. ", " .. transform:z())
    self.tracking:SetPosition(transform, rotation:ToQuaternion())
    return true
  end
  return false
end

function facemesh:Update(def)
  if self.tracking then
    local tracking_data = self:GetTrackingData();
    if self:Positioning() then
      if(tracking_data == nil) then
        self.tracking:ShowModel(false)
        ERROR("No Tracking data")
        return;
      end
      self.tracking:UpdateModel(tracking_data, def);
      self.tracking:ShowModel(true);
    else
      self.tracking:ShowModel(false);
    end
  end
end

return facemesh