local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"
local metascene = require "facecute.3dsticker.metascene"
local modelnode3New = require "facecute.3dsticker.modelnode3New"
local modelnode3Old = require "facecute.3dsticker.modelnode3Old"
require "venusdebug"


--管理一组3d模型
local threesticker = Object:extend();

function threesticker:new()
  self.assets = {}
end                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       

function threesticker:subString(str, k)
  local ts = string.reverse(str)
  local _, i = string.find(ts, k)
  if i==nil then 
   return nil
  end
  local m = string.len(ts) - i + 2

  return string.sub(str, m, string.len(ts))
end
--传入数据表，解析数据
function threesticker:ParseConfig(config,para)
  --_COROUTINES_ON();
  local res = true;
  --local json = venusjson.LaodJsonFile(config);
  if (config["parts3d"]) then   --模型

    local metaSceneConfig = para["metascene"];

    local parts3DValue = config["parts3d"];
    local modellist = parts3DValue["modelList"];
    local scene =nil
    if metaSceneConfig~=nil then
      local goNameList = {}; 
      for key, value in pairs(modellist) do
        local fileName = value["fileName"];
        local goName = value["name"];
        goNameList[goName] = fileName;
      end

      scene = metascene();
      res = scene:ParseConfig3(metaSceneConfig, para, goNameList, true);
    end
    
    for key, value in pairs(modellist) do
      local modelName = value["fileName"];
      local goName = value["name"];
      local modelPath = para[1] .. "/" .. modelName;
      local model = nil
      local modelConfig = venusjson.LaodJsonFile(modelPath .. "/config.json")
      if modelConfig ~= nil then
          if modelConfig.version == nil or modelConfig.version < 3 then
              model = modelnode3Old()
          else
              model = modelnode3New()
          end
      end
      modelConfig = nil
      if scene~=nil then
        local submeshTexTable,submeshRefTable = scene:GetSubMeshAndTex(goName);
        model:SetTexturePath(submeshTexTable,submeshRefTable);
      end
      res = res and model:CreateResource(modelPath);
      
      model:SetShow(false);
      model:SetLoop(true);
      model:Play();

      renderqueue:After(model);
      table.insert(self.assets, model);
    end
  end
  return res;
  --_COROUTINES_OFF();
end

function threesticker:getAsset(name)
  return nil;
end

function threesticker:SetShow(isshow)
  for _, model in ipairs(self.assets) do
    model:SetShow(isshow);
  end  
end

function threesticker:SetRootNode(node)
  for _, model in ipairs(self.assets) do
    node:AttachNode(model);
  end  
end

function threesticker:Update(timespan)
  for _, model in ipairs(self.assets) do
    model:UpdateAnimation(timespan);
  end
end

function threesticker:ReleaseResource()
  if self.assets~=nil then
    for i =1,  #self.assets do
      self.assets[i]:Destroy();
    end
    self.assets = nil;
  end
end

return threesticker;
