
local TransNode = require "apolloutility.apollonode.trasnnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local util = require "behavior.avatar_behavior.util"
local apolloDefine = require "apolloutility.defiend"

local laplacianVirtualpoint = {};


function laplacianVirtualpoint:SetHeadSize(x,y,z)
  self.XExtent = x;
  self.YExtent = y;
  self.ZExtent = z;
end

function laplacianVirtualpoint:SetBodySize(x,y,z)
  self.XExtentBody = x;
  self.YExtentBody = y;
  self.ZExtentBody = z;
end

function laplacianVirtualpoint:SetHeadTransform(position,rotation)
    self.headpos = mathfunction.vector3(position[1],position[2],position[3]);
    self.headrotation = mathfunction.Quaternion(rotation[1],rotation[2],rotation[3],rotation[4]);
end

function laplacianVirtualpoint:SetBodyTransform(position,rotation)
    self.bodypos = mathfunction.vector3(position[1],position[2],position[3]);
    self.bodyrotation = mathfunction.Quaternion(rotation[1],rotation[2],rotation[3],rotation[4]);
end

function laplacianVirtualpoint:SetVirtualPointsSplit(split)
    self.split = split;
end

function laplacianVirtualpoint:GetVirtualPoints()
    local result = {};
    for i=1,self.split do
      local x =  -self.XExtent/2 + (i-1)*self.XExtent/(self.split-1);
      local pose = mathfunction.vector3(x,0,0);
      local worldpose =  self.headpos+pose*self.headrotation;
      local ret = {};
      ret[1] = worldpose:x();
      ret[2] = worldpose:y();
      ret[3] = worldpose:z();
      table.insert(result,ret);
    end  

    for i=1,self.split do
      local z = self.ZExtent/2 - (i-1)*self.ZExtent/(self.split-1);  
      local pose = mathfunction.vector3(0,0,z);
      local worldpose =  self.headpos+pose*self.headrotation;
      local ret = {};
      ret[1] = worldpose:x();
      ret[2] = worldpose:y();
      ret[3] = worldpose:z();
      table.insert(result,ret);
    end
    
    for i=1,self.split do
      local x =  -self.XExtentBody/2 + (i-1)*self.XExtentBody/(self.split-1);
      local pose = mathfunction.vector3(x,0,0);
      local worldpose =  self.bodypos+pose*self.bodyrotation;
      local ret = {};
      ret[1] = worldpose:x();
      ret[2] = worldpose:y();
      ret[3] = worldpose:z();
      table.insert(result,ret);
    end  

    for i=1,self.split do
      local z = self.ZExtentBody/2 - (i-1)*self.ZExtentBody/(self.split-1);  
      local pose = mathfunction.vector3(0,0,z);
      local worldpose =  self.bodypos+pose*self.bodyrotation;
      local ret = {};
      ret[1] = worldpose:x();
      ret[2] = worldpose:y();
      ret[3] = worldpose:z();
      table.insert(result,ret);
    end
    

    
    return result;
end

return laplacianVirtualpoint;