local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local apolloDefine = require "apolloutility.defiend"


local capsulecollision = {}

function capsulecollision:collide(point,radius, pointra,pointrb,radiusr)

  local ox = point - pointra;
  local temp = pointrb-pointra;
  local length = temp:Length();
  local dir = temp:Normalize();
  local projectLength = ox:Dot(dir);
  if projectLength<0  then
    return self:collidesphere(point,radius,pointra,radiusr);
  elseif projectLength>length then
    return self:collidesphere(point,radius,pointrb,radiusr);
  end
  local normal = ox - (dir*projectLength);
  local distance = normal:Length();
  if distance>=(radiusr+radius) then
    return false,nil;
  end
  local nornormal = normal / distance;
  local offset = nornormal * (radiusr+radius - distance);
  
  return true,offset;
end

function capsulecollision:collidesphere(pointa,radiusa, pointb,radiusr)
  local disvec = pointa- pointb;
  local dis = disvec:Length();
  if dis<radiusr+radiusa then
    local offset = disvec*(radiusr+radiusa-dis)/dis;
    return true,offset;
  end
  return false,nil;
end
return capsulecollision;