local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local defined = require "behavior.cartoon_behavior.defined"
local utils = require "behavior.cartoon_behavior.utils"

local AnimationPlayBehavior = venuscore.VenusBehavior:extend("AnimationPlayBehavior")
local CONTROLLER_SCRIPT = "load_behavior.lua"

function AnimationPlayBehavior:new()
  AnimationPlayBehavior.super.new(self)
  self.status = defined.animation_status.PLAYING
  self.started = false
end

function AnimationPlayBehavior:_OnAwake()
  if self.Node:HaveComponent(apolloengine.Node.CT_ANIMATION) then
    self.animation = self.Node:GetComponent(apolloengine.Node.CT_ANIMATION)
  end

  if self.Controller ~= nil then
    self:RegisterNode()
  end
end

function AnimationPlayBehavior:_OnUpdate(delta)
  if self.started then
    self.status = self:GetAnimationStatus()
  end
end

function AnimationPlayBehavior:Play()
  self:PlayAnimation()
  self.started = true
end

function AnimationPlayBehavior:PlayAnimation()
  if self.animation == nil then
    return
  end
  LOG("CARTOON: animation reset and play")
  self.animation:Reset()
  self.animation:Play()
end

function AnimationPlayBehavior:GetStatus()
  return self.status
end

function AnimationPlayBehavior:GetAnimationStatus()
  if self.animation == nil then
    return defined.animation_status.DONE
  end
  local status = self.animation:GetAnimationStatus()
  if status == apolloengine.IComponent.AS_ERROR then
    return defined.animation_status.ERROR
  elseif status == apolloengine.IComponent.AS_DONE then
    return defined.animation_status.DONE
  elseif status == apolloengine.IComponent.AS_STOP then
    return defined.animation_status.STOP
  end
  return defined.animation_status.PLAYING
end

function AnimationPlayBehavior:RegisterNode()
  local controller_behavior = utils:GetBehavior(self.Controller, CONTROLLER_SCRIPT)
  if controller_behavior ~= nil then
    controller_behavior:RegisterAnimationNode(self.Node)
  end
end

AnimationPlayBehavior:MemberRegister(
  "Controller",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),    
    nil,
    function(thiz, value)
      thiz.Controller = value
      thiz:RegisterNode()
    end
  )
)

return AnimationPlayBehavior