local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local meshnode = require "apolloutility.apollonode.meshnode"
local toondefined = require "apolloutility.apollonode.toonmodel.toondefined"
local toonshader = require "apolloutility.apollonode.toonmodel.toonshader"
--模型节点
local MeshNodeToon = meshnode:extend();
function MeshNodeToon:new()
  MeshNodeToon.super.new(self);
  self.matSrcType = toondefined.matsrcType.File;
end

function MeshNodeToon:SetMaterialSrcType(srct)
  self.matSrcType = srct;
end


function MeshNodeToon:SetToonShader(toonname)
  self.toon = toonshader();
  --local requirestr = "apolloutility.apollonode.toontype."..toonname;
  local toonconfig = require ("apolloutility.apollonode.toonmodel.toontype."..toonname);
  self.toon:Parse(toonconfig.Shader,toonconfig.Properties);
  
end


function MeshNodeToon:CreateResource(meshpath,materialpath,skeletonPath,animationpath,frameCount,aniType, mu)
  
  --mesh
  if(self.matSrcType==toondefined.matsrcType.File)
  then
    self.render:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(                                                                                                                                                                                                                                       
        apolloengine.PathMetadata(materialpath)));
  elseif(self.matSrcType==toondefined.matsrcType.String)
  then
    
     if(self.toon)
    then
       local srcMatString = self.toon:GetMatSrc();
       
        --LOG(srcMatString)
    
       self.render:PushMetadata(
        apolloengine.RenderObjectMaterialMetadata(
        apolloengine.StringBufferMetadata(srcMatString)));
     else
       self.render:PushMetadata(
        apolloengine.RenderObjectMaterialMetadata(
        apolloengine.StringBufferMetadata(materialpath)));
     end
    
  end
    
  if mu == nil then
    mu = apolloengine.VertexBufferEntity.MU_STATIC;
  end   

  self.render:PushMetadata(
		apolloengine.RenderObjectMeshFileMetadate(mu, meshpath));
  local res = self.render:CreateResource();
      
  --skeleton
  if(animationpath) then
    self.skeleton = self.node:CreateComponent(apolloengine.Node.CT_SKELETON)
    self.frameCount = 0;
    --self.skeleton:PushMetadata(apolloengine.PathMetadata(skeletonPath),apolloengine.PathMetadata(animationpath));
    self.skeleton:PushMetadata(apolloengine.SkeletonAnimationFileMetaData(aniType,skeletonPath,animationpath));
    
    res = res and self.skeleton:CreateResource();
    --set default interval
    self.skeleton:SetAnimationInterval(0,frameCount-1);
    self.frameCount = frameCount;
  end
  
  if(res and self.toon)
  then
    self.toon:InitProperty(self.render);
  end
  
  return res;
end

--function MeshNodeToon:InitProperty()
  
  --if( self.toon)
 -- then
   -- self.toon:InitProperty(self.render);
 -- end
--end
return MeshNodeToon;