local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "utility"


local QuadNode = rendernode:extend();

--0-------2
--|	    / |
--|	  /   |
--| / 	  |
--1-------3
function QuadNode:new()
  QuadNode.super.new(self);
  self.node:SetName("QuadNode");
end

function QuadNode:CreateResource(materialpath, flip, flat)
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(materialpath)));
  flip = flip or false;
  flat = flat or false;
  self.render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			apolloengine.RenderComponent.RM_TRIANGLES,      
      apolloengine.QuadVertexMetadata(flip, flat),
      apolloengine.QuadIndicesMetadata()));
  return self.render:CreateResource();
end

--指定区域Quad
function QuadNode:CreateResourceSpecific(materialpath,verterxStream, indexStream)
  self.super.CreateResource(self, materialpath, apolloengine.RenderComponent.RM_TRIANGLES, verterxStream, indexStream);
end

--指定区域Quad
function QuadNode:CreateResourceSpecificRendermode(materialpath,verterxStream, indexStream, rendermode)
  self.super.CreateResource(self, materialpath, rendermode, verterxStream, indexStream);
end

--将Quad细分
function QuadNode:CreateResourceSplited(materialpath, flip, flat, splitw, splith)
  
  local vertexStream,indexStream = Tesslate(splitw, splith,flat,flip);
  
  self.super.CreateResource(self,materialpath, apolloengine.RenderComponent.RM_TRIANGLES, vertexStream, indexStream);
end


function QuadNode:CreateResourceByMaterialBuffer(material_buffer,flip,flat)
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.StringBufferMetadata(material_buffer)));
  flip = flip or false;
  flat = flat or false;
  self.render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			apolloengine.RenderComponent.RM_TRIANGLES,      
      apolloengine.QuadVertexMetadata(flip, flat),
      apolloengine.QuadIndicesMetadata()));
  return self.render:CreateResource();
end

return QuadNode;
