
#DEFPARAMS
FRAME_TEXTURE = { "Frame Tex", TEXTURE2D, "white" },
BRIGHT_TEXTURE = { "Bright Tex", TEXTURE2D, "white" },
UNIFORM_LIGHT_COLOR = { "Offset", VEC3, "0.0,0.0,0.0" },
SAMPLES = { "Samples", FLOAT, "0.0" },
STEP = { "Step", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "ShineVolumnLight"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D FRAME_TEXTURE;
Texture2D BRIGHT_TEXTURE;
SamplerState FRAME_Sampler;
SamplerState BRIGHT_Sampler;
float3 UNIFORM_LIGHT_COLOR;
float SAMPLES;
float STEP;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	int samples = int(SAMPLES);
    // Screen coordinates.
	float2 texcoord = i.uv;
    float2 uv = i.uv;//fragCoord.xy / iResolution.xy;

    float decay = 0.7; 
    float density = 1.0; 
    float weight = 0.6; 
    //const float SAMPLES = 30.0;
    // vec3 lightColor = vec3(1.0, 0.6, 0.6)*0.5;
	// const float step = 0.005;

	float2 tuv =  uv - float2(0.5, 0.5);
	float dis = length(tuv);
	
    float2 dTuv = dis > SAMPLES * STEP ? normalize(tuv) * STEP: tuv / SAMPLES;
    float sum_brightness = 0.0;
 
	float delta_step = 1.0 / SAMPLES;
	float cur_dis = 1.0;
	for(int i= 0; i < samples; i++)
	{
        uv -= dTuv;
        sum_brightness += BRIGHT_TEXTURE.Sample(BRIGHT_Sampler, uv).r  * 0.05 * cur_dis * cur_dis;
		cur_dis -= delta_step;
    }

	//sumBrightness = min(sumBrightness, 0.7);
	//sumBrightness *= (1.0 - dis / 0.7)*(1.0 - dis / 0.7);
	float3 rgb = FRAME_TEXTURE.Sample(FRAME_Sampler, texcoord).xyz;
	float3 res_color = rgb + UNIFORM_LIGHT_COLOR * sum_brightness;
	mainColor = float4(res_color, 1.0);
}
ENDCG
#END
