#SHADER_DEFINE DustVertex
    FUNCTION_INPUT = 
  {
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoord"},
  }

  FUNCTION_OUTPUT = 
  {
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCoord" },
  }
    
#SHADER_CODE
    vec2 out_TexCoord = in_TexCoord;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE

#SHADER_DEFINE DustFragment
  FUNCTION_INPUT = 
  {		
        { FRAME_SIZE,		           HIGH,	  FLOAT,		    "in_FrameSize"},
        { CUR_FRAME_ID,            HIGH,    FLOAT,        "in_CurFrameID"},
        { RESOLUTION,	             HIGH,    VEC2,		      "in_Resolution"},        
        { SAMPLE_SIZE,	           HIGH, 	  VEC2,		      "in_SampleSize"},
        { HISTORICAL_FRAMES,	     HIGH, 	  FLOAT,		    "in_HistoricalFrames"},        
        { ROW_FRAME_NUM_PER_TEX,   HIGH,	  FLOAT,		    "in_RowFrameNumPerTex"},
        { COL_FRAME_NUM_PER_TEX,   HIGH,	  FLOAT,		    "in_ColFrameNumPerTex"},
        { HISTORICAL_FRAME1,	     NONE,	  TEXTURE2D,		"in_Tex1" },
        { HISTORICAL_FRAME2,	     NONE,  	TEXTURE2D,		"in_Tex2" },
        { HISTORICAL_FRAME3,	     NONE,  	TEXTURE2D,		"in_Tex3" },
        { HISTORICAL_FRAME4,	     NONE,  	TEXTURE2D,		"in_Tex4" },        
        { NOISE_TEXTURE,	         NONE,  	TEXTURE2D,		"in_Noise" },        
        { ATTRIBUTE_COORDNATE0,	   HIGH,  	VEC2,		      "in_TexCoord"},
  }
  
#SHADER_CODE
    highp int iFrameSize = int(in_FrameSize);
    highp int iCurFrameID = int(in_CurFrameID);
    highp int iRowFrameNumPerTex = int(in_RowFrameNumPerTex);
    highp int iColFrameNumPerTex = int(in_ColFrameNumPerTex);
    
    vec2 xy = in_TexCoord * in_Resolution;
    vec2 uv = (floor(xy / in_SampleSize) * in_SampleSize) / in_Resolution; 

    float r = texture2D(in_Noise, uv).r;
    
    int minus_frames = int(r * in_HistoricalFrames);
    int frame_id = int(mod(iCurFrameID - minus_frames, iFrameSize));

    int FRAME_NUM_PER_TEX = iRowFrameNumPerTex * iColFrameNumPerTex;
    int tex_id = frame_id / FRAME_NUM_PER_TEX;
    int local_frame_id = int(mod(frame_id, FRAME_NUM_PER_TEX));
    
    float x_scale = 1.0 / in_RowFrameNumPerTex;
    float y_scale = 1.0 / in_ColFrameNumPerTex;        
    
    int divide = local_frame_id / iRowFrameNumPerTex;
    float tex_x_start = x_scale * mod(local_frame_id, iRowFrameNumPerTex);
    float tex_y_start = y_scale * float(iColFrameNumPerTex - 1 - divide);

    vec2 tex_pos = vec2(tex_x_start, tex_y_start) + vec2(x_scale, y_scale) * in_TexCoord;
   
    vec3 rgb = vec3(0.0, 0.0, 0.0);
    if (tex_id == 0)
      rgb = texture2D(in_Tex1, tex_pos).rgb;
    else if (tex_id == 1)
      rgb = texture2D(in_Tex2, tex_pos).rgb;
    else if (tex_id == 2)
      rgb = texture2D(in_Tex3, tex_pos).rgb;
    else if (tex_id == 3)
      rgb = texture2D(in_Tex4, tex_pos).rgb;
      
    gl_FragColor = vec4(rgb,1.0);
#END_CODE
#END_DEFINE