local apollonode = require "apolloutility.apollonode"
local headtargetgame =  require "game.headtargetgame";

local immortalgame = headtargetgame:extend();

function immortalgame:new(maincamera)
  self.assets = {};--保存全部的资源
  self.sounds = {};--声音要全部停止
  self.maincamera = maincamera;
  self.headtrans = apollonode.TransNode();
end

--设置是否显示
function immortalgame:SetShow(isshow)
  for _, node in ipairs(self.assets) do
    node:SetShow(isshow);
  end  
end


--更新
function immortalgame:Update(timespan, face, position, rotation, action)
  for _, node in ipairs(self.assets) do
    node:Update(timespan, face, position, rotation, action);
  end  
end

function immortalgame:ReleaseResource()
  self.headtrans:Destroy();
  immortalgame.super.ReleaseResource(self);
end

return immortalgame;
