local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local videodecet = require "videodecet"
local soundplayer = require "soundplayer"
local faceinfo = require "videodecet.faceinfo"
local mathfunction = require "mathfunction"
local math = require "math"
local venuscore = require "venuscore"

local dollymain={};
dollymain.time=0;
dollymain.t=1;
--缩放时间点列表
dollymain.basetime = {0.0,6.4,  6.6,6.65,15.0};
--与缩放时间点相对应的尺寸
dollymain.scale = {0.0,0.2,  0.5,0.5,0.8};
--划分几个关键时间点 
dollymain.part = 5;
function dollymain:_arrayToVec2(pt)
  return mathfunction.vector2(pt[1],pt[2]);
end

function dollymain:Initialize(camera,config)
  self.time = 0;
  self.maincamera = camera;
  self.post = self.maincamera:CreatePostEffect();
  self.lpath = venuscore.IFileSystem:PathAssembly("docs:filter/tuijing2/filter/resource");
  
  self.post:CreateResource(self.lpath.."/dolly.lua"); 
  self.post:RegisterParameter("UNIFORM_CENTER",self.lpath.."/material/whydolly.material");
  self.post:RegisterParameter("UNIFORM_SCALE",self.lpath.."/material/whydolly.material");
  self.post:UNIFORM_SCALE(mathfunction.vector1(1.0));
  self.post:UNIFORM_CENTER(mathfunction.vector2(0.0, 0.0));  
  
  self.soundpath = "ress:"..config.filter.Sound;
  self.spath = venuscore.IFileSystem:PathAssembly(self.soundpath);
  --LOG(venuscore.IFileSystem:PathAssembly(self.soundpath));
  self.soundplayerDetect = soundplayer();
  local res = self.soundplayerDetect:LoadSound(self.spath);
  self.soundplayerDetect:PlaySound(0);   
  
end

function dollymain:Update(def)
  self.time = self.time + def;
  local faces = videodecet:GetFaces();
  local maxFaceNum = 1;
  if faces and faces[1] then
    local faceinfo = faces[1];
    local keypoints = faceinfo:GetKeypointArray();
    self.center = (self:_arrayToVec2(keypoints[78])+self:_arrayToVec2(keypoints[75]))*0.5;
  else
    self.center = mathfunction.vector2(0.0, 0.0);
  end
  if(self.time>self.basetime[self.part]) then
    self.time = 0.0;
    self.t = 1;
  end
  if(self.time>=self.basetime[self.t]) then
    self.t =self.t+1;
  end
  local newscale = (self.scale[self.t]-self.scale[self.t-1])*(self.time-self.basetime[self.t-1])/(self.basetime[self.t]-self.basetime[self.t-1])+self.scale[self.t-1];
  self.post:UNIFORM_SCALE(mathfunction.vector1(newscale));
  self.post:UNIFORM_CENTER(self.center);
end

function dollymain:OnRecordStart()
  self.time = 0;
  self.t = 1;
  self.soundplayerDetect:StopSound();
  self.soundplayerDetect:PlaySound(0);
end

function dollymain:Exit()
  self.post:Disable();
  self.maincamera:DeletePostEffect(self.post);
  self.post = nil;
  self.soundplayerDetect:StopSound();
end

return dollymain;
