local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local videodecet = require "videodecet"
local soundplayer = require "soundplayer"
local mathfunction = require "mathfunction"
local define = require "videodecet.defined"
local math = require "math"
local venuscore = require "venuscore"

local ripplemain={};
ripplemain.time= 0;
--水纹扩散速度
ripplemain.speed = 0.85;
--水纹宽度
ripplemain.wavewidth = 0.18;
--水纹密集程度
ripplemain.disfactor = {20.0,21.0,20.0};
--水纹波动效果
ripplemain.timefactor = -20.0;
--水纹大小
ripplemain.ampfactor = {0.8,0.8,0.8};
--判断手指触屏尺寸
ripplemain.fingersize = 0.1;

ripplemain.point = mathfunction.vector2array();
ripplemain.t = {0.0,0.0,0.0};
ripplemain.center = {{-10.0,-10.0},{-10.0,-10.0},{-10.0,-10.0}};
ripplemain.r = {2.0,2.0,2.0};
ripplemain.num = 1;

function ripplemain:_arrayToVec2(pt)
  return mathfunction.vector2(pt[1]*0.5 + 0.5,pt[2]*0.5 + 0.5);
end

function ripplemain:GetDistance(src, dst)
  local dx = src[1] - dst[1];
  local dy = src[2] - dst[2];
  return math.sqrt(dx * dx + dy * dy);
end

function ripplemain:Initialize(camera,config)
  
  self.maincamera = camera;
  self.post = self.maincamera:CreatePostEffect();
  self.lpath = venuscore.IFileSystem:PathAssembly("docs:filter/ripple/filter/resource");
  
  self.post:CreateResource(self.lpath.."/ripple.lua"); 
  self.post:RegisterParameter("UNIFORM_TIME",self.lpath.."/material/ripple.material");
  self.post:RegisterParameter("UNIFORM_POINT",self.lpath.."/material/ripple.material");
  self.post:RegisterParameter("UNIFORM_RADIUS",self.lpath.."/material/ripple.material");
  self.post:RegisterParameter("UNIFORM_WAVEWIDTH",self.lpath.."/material/ripple.material");
  self.post:RegisterParameter("UNIFORM_DISFACTOR",self.lpath.."/material/ripple.material");
  self.post:RegisterParameter("UNIFORM_AMPFACTOR",self.lpath.."/material/ripple.material");
  
  local point = mathfunction.vector2array();
  self.post:UNIFORM_POINT(self.point);
  
  self.post:UNIFORM_TIME(mathfunction.vector1(self.time * self.timefactor));
  self.post:UNIFORM_WAVEWIDTH(mathfunction.vector1(self.wavewidth));
  self.post:UNIFORM_DISFACTOR(mathfunction.vector3(self.disfactor[1],self.disfactor[2],self.disfactor[3]));
  self.post:UNIFORM_AMPFACTOR(mathfunction.vector3(self.ampfactor[1],self.ampfactor[2],self.ampfactor[3]));
  self.post:UNIFORM_RADIUS(mathfunction.vector3(self.r[1],self.r[2],self.r[3]));
  
  self.soundpath = "ress:"..config.filter.Sound;
  self.spath = venuscore.IFileSystem:PathAssembly(self.soundpath);
  LOG(venuscore.IFileSystem:PathAssembly(self.soundpath));
  self.soundplayerDetect = soundplayer();
  local res = self.soundplayerDetect:LoadSound(self.spath);
  --self.soundplayerDetect:PlaySound(0);   
  
  videodecet:ActiveActions({define.triggerType.IndexFinger});
  --self.maincamera:AttachPostEffect(self.post);
  
end

function ripplemain:Update(def)
  
  self.time = self.time + def;
  
  local people = videodecet: GetActions();
  local peoplenum = 0;
  if people then
    peoplenum = #people;
  end
  for i = 1, peoplenum, 1 do
    local action = people[i];
    local actionnum = 0;
    if action then
      actionnum = #action;
    end
    for k = 1, actionnum, 1 do
      local actioninfo = action[k];
      local actiontype = actioninfo:GetActionID();
      local actionrect = actioninfo:GetRect();
      local dis = self:GetDistance({actionrect[1],actionrect[2]},{actionrect[3],actionrect[4]});
      if actiontype == define.triggerType.IndexFinger and dis > self.fingersize and self.r[self.num] > 0.75 then
        if self.num + 1 > 3 then
          self.num = 1;
        else
          self.num = self.num + 1;
        end
        self.t[self.num] = self.time;
        local c = actioninfo:GetCenter();
        self.center[self.num][1] = c[1];
        self.center[self.num][2] = c[2];
        
        --获取随机波纹大小，范围0.05~0.25
        self.ampfactor[self.num] = math.random(5,8)*0.1;
        --获取随机波纹密集程度，范围40~70
        self.disfactor[self.num] = math.random(20,25);
        
        self.soundplayerDetect:StopSound();
        --触发水纹同时触发声音
        self.soundplayerDetect:PlaySound(1);
        
      end
    end
  end
  
  self.r[1] = (self.time - self.t[1]) * self.speed;
  self.r[2] = (self.time - self.t[2]) * self.speed;
  self.r[3] = (self.time - self.t[3]) * self.speed;
  self.post:UNIFORM_RADIUS(mathfunction.vector3(self.r[1],self.r[2],self.r[3]));
  
  self.post:UNIFORM_AMPFACTOR(mathfunction.vector3(self.ampfactor[1],self.ampfactor[2],self.ampfactor[3]));
  self.post:UNIFORM_DISFACTOR(mathfunction.vector3(self.disfactor[1],self.disfactor[2],self.disfactor[3]));
  
  local point = mathfunction.vector2array();
  point:PushBack(self:_arrayToVec2(self.center[1]));
  point:PushBack(self:_arrayToVec2(self.center[2]));
  point:PushBack(self:_arrayToVec2(self.center[3]));
  self.post:UNIFORM_POINT(point);
  self.post:UNIFORM_TIME(mathfunction.vector1(self.time * self.timefactor));
  
end

function ripplemain:OnRecordStart()
  self.time = 0;
  ripplemain.t = {0.0,0.0,0.0};
  ripplemain.center = {{-10.0,-10.0},{-10.0,-10.0},{-10.0,-10.0}};
  ripplemain.r = {2.0,2.0,2.0};
  ripplemain.num = 1;
  self.soundplayerDetect:StopSound();
  --self.soundplayerDetect:PlaySound(0);
end

function ripplemain:Exit()
  self.post:Disable();
  self.maincamera:DeletePostEffect(self.post);
  self.post = nil;
  self.soundplayerDetect:StopSound();
end

return ripplemain;
