#SHADER_DEFINE HairSegVertex

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;

#END_CODE
#END_DEFINE

#SHADER_DEFINE HairSegFragment

	FUNCTION_INPUT =
	{
    { TEXTURE_DIFFUSE,		      NONE,	TEXTURE2D,  "in_SrcTexture" },
    { TEXTURE_MASK,             NONE, TEXTURE2D,  "in_ColorMask"},
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		    "in_TexCoordinate"},
  }

FUNCTION_OUTPUT =
	{
	}

#SHADER_CODE
    highp vec4 mask = texture2D(in_ColorMask, vec2(in_TexCoordinate.x, in_TexCoordinate.y));
    highp vec4 src_color = texture2D(in_SrcTexture,vec2(in_TexCoordinate.x, in_TexCoordinate.y));
    highp float alpha = src_color.a * mask.r;
   // 
    gl_FragColor = vec4(src_color.rgb,alpha);
#END_CODE
#END_DEFINE