//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////
#include "functions/rgb_hsv.function"
#include "functions/lut.function"
#include "functions/brightadjust.function"

#SHADER_DEFINE ChangeColorVertexV2

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;

#END_CODE
#END_DEFINE

#SHADER_DEFINE ChangeColorFragmentV2

	FUNCTION_INPUT =
	{
    { TEXTURE_DIFFUSE,		      NONE,	TEXTURE2D,  "in_SrcTexture" },
    { TEXTURE_TO_COLOR,         NONE, TEXTURE2D,  "in_ToColor"},
    { TEXTURE_MASK,             NONE, TEXTURE2D,  "in_ColorMask"},
    { TEXTURE_LUT,		          NONE,	TEXTURE2D,	"in_TextureLUT" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		    "in_TexCoordinate"},
    { BIRGHTNESS,               HIGH, FLOAT,      "in_Brightness"},
    --{ BIRGHTNESS_RANGE,         HIGH, VEC2,       "in_BrightnessRange"},
    --{ BRIGHTNESS_RANGE,        HIGH, VEC3,       "in_BrightnessRange"},
    {BRIGHTNESS_CURVECOEF,          HIGH, VEC4,        "in_BrightnessCurveCoef"},
    {SATURATION_CURVECOEF,          HIGH, VEC4,        "in_SaturationCurveCoef"},
    --{XYMIN,HIGH,VEC2,"xymin"},
    --{XYMAX, HIGH, VEC2,"xymax"},
  }

FUNCTION_OUTPUT =
	{
	}

#SHADER_CODE
    highp vec4 mask = texture2D(in_ColorMask, vec2(in_TexCoordinate.x,1.0 - in_TexCoordinate.y));
    highp vec4 src_color = texture2D(in_SrcTexture,vec2(in_TexCoordinate.x, 1.0 - in_TexCoordinate.y));
    highp vec3 src_hsv = rgb2hsv(src_color.xyz);
    //对头发原亮度进行亮度映射
    highp float final_src_brightness = 0.0;
    /*if (src_hsv.z < 0.5)
      final_src_brightness = in_BrightnessRange.x + (src_hsv.z / 0.5) * (in_BrightnessRange.y - in_BrightnessRange.x);
    else
      final_src_brightness = in_BrightnessRange.y + ((src_hsv.z - 0.5) / 0.5 )* (in_BrightnessRange.z - in_BrightnessRange.y);*/
    //调亮度曲线
    //final_src_brightness = brightadjust(in_BrightnessCurveCoef.x,in_BrightnessCurveCoef.y,in_BrightnessCurveCoef.z,in_BrightnessCurveCoef.w,src_hsv.z);
    //final_src_brightness = exp(-src_hsv.z*5.0) * src_hsv.z * (1.0+0.8 - src_hsv.z)*1.3 +src_hsv.z;
    final_src_brightness = exp(-src_hsv.z*6.5) * src_hsv.z * (1.0+0.6 - src_hsv.z)*1.4 +src_hsv.z;
    highp vec4 in_ToColor = texture2D(in_ToColor,in_TexCoordinate);
    highp vec3 dst_hsv = rgb2hsv(in_ToColor.xyz);
    src_hsv = vec3(dst_hsv.x,dst_hsv.y,final_src_brightness);  //调整亮度
    highp vec3 dst_rgb = clamp(hsv2rgb(src_hsv),vec3(0.0,0.0,0.0),vec3(1.0,1.0,1.0));
    dst_hsv = rgb2hsv(dst_rgb);
    //调饱和度曲线
    float saturaion = brightadjust(in_SaturationCurveCoef.x,in_SaturationCurveCoef.y,in_SaturationCurveCoef.z,in_SaturationCurveCoef.w,dst_hsv.y);
    src_hsv = vec3(dst_hsv.x,saturaion,dst_hsv.z);

    dst_rgb = clamp(hsv2rgb(src_hsv),vec3(0.0,0.0,0.0),vec3(1.0,1.0,1.0));
    highp float maskf = clamp((1.0 - in_ToColor.a) + (1.0 - mask.r),0.0,1.0);
    highp vec3 final_rgb = (src_color.rgb * maskf) + (dst_rgb * (1.0 - maskf));
    gl_FragColor = vec4(final_rgb,src_color.a);

    //以下测试用
    //gl_FragColor = in_ToColor + src_color + mask;
    //画rect范围
    //if(in_TexCoordinate.x >xymin.x*0.5+0.5 && in_TexCoordinate.y >xymin.y*0.5+0.5 && in_TexCoordinate.x< xymax.x*0.5+0.5 && in_TexCoordinate.y <xymax.y*0.5+0.5){
      //gl_FragColor = mask;
    //}
#END_CODE
#END_DEFINE
