//
//	Vertex Shader for Special Tunnel Effect
//  Based on default Texture
//

attribute vec4 ATTRIB_Vertex;
attribute mediump vec3 ATTRIB_Normals;
attribute vec2 ATTRIB_TextureUV;
attribute vec4 ATTRIB_Colour;
attribute vec4 ATTRIB_NormalMap;
attribute vec4 ATTRIB_Tangents;
attribute vec2 ATTRIB_SecondaryTextureUV;			// Second multi-texturing UV data set.

uniform mat4 INPUT_ModelMatrix;				// Model matrix
uniform mat4 INPUT_ModelProjMatrix;			// Projection * Model matrix
uniform mat4 INPUT_NormalMatrix;

uniform vec4 INPUT_DiffuseColour;
uniform vec4 INPUT_AmbientColour;

uniform int  INPUT_DirectionalLight0Enabled;
uniform vec3 INPUT_DirectionalLight0Direction;
uniform vec3 INPUT_DirectionalLight0HalfVector;

uniform int  INPUT_PointSpotLight0Enabled;
uniform vec3 INPUT_PointSpotLight0Position;				// Position is in transformed view space...
uniform vec3 INPUT_PointSpotLight0Direction;
uniform vec3 INPUT_PointSpotLight0HalfVector;

uniform highp float INPUT_Time;

uniform sampler2D SAMPLER_NormalMap;

// Data passed from the Vertex shader to the Facet shader:

varying mediump vec3 VtoF_ViewDirection;
varying mediump vec3 VtoF_UntransformedViewDirection;

varying mediump vec4 VtoF_Ambient;
varying highp   vec3 VtoF_Normal;
varying mediump vec4 VtoF_Colour;						// A combination of diffuse colour and vertex colour
varying mediump vec2 VtoF_TextureCoord;
varying mediump vec2 VtoF_TextureCoordCentered;

#if (defined TEXTURING_1_SRCA_1MINUSSRCA) || (defined TEXTURING_1_1_SRCA) || (defined TEXTURING_1_CROSSFADE)
varying mediump vec2 VtoF_SecondaryTextureCoord;
#endif 

varying highp float VtoF_Time;

void main()
{
    vec3 D0lightDir;
    vec3 P0lightDir;

    vec4 newModelPosition = INPUT_ModelMatrix * ATTRIB_Vertex;
    vec4 newPosition = INPUT_ModelProjMatrix * ATTRIB_Vertex;
   
	mediump mat3 NormalView3 = mat3(INPUT_NormalMatrix[0].xyz , INPUT_NormalMatrix[1].xyz, INPUT_NormalMatrix[2].xyz);
	vec3 newNormal = vec3(normalize(NormalView3 * ATTRIB_Normals));

#ifdef NORMAL_MAPPING
    vec3 n = newNormal;
    vec3 t = normalize(ATTRIB_Tangents.xyz);
    vec3 b = cross(n, t) * ATTRIB_Tangents.w; // * gl_MultiTexCoord1.w;
    mat3 tbnMatrix = mat3(t.x, b.x, n.x,
                          t.y, b.y, n.y,
                          t.z, b.z, n.z);

	VtoF_UntransformedViewDirection = vec3(newModelPosition.xyz);                           
	VtoF_ViewDirection = tbnMatrix * vec3(newModelPosition.xyz);
	
	// Directional Light - transform the light direction by the normal matrix
	// to align it with the surface normal...(tangent space)... 
	// Then then normal map texture provides deviations from that normal.. 
	//===================
	D0lightDir = normalize(vec3(INPUT_DirectionalLight0Direction));
   	VtoF_DirectionalLight0_Dir = tbnMatrix * D0lightDir;
   	VtoF_DirectionalLight0_HalfVector = normalize(tbnMatrix * INPUT_DirectionalLight0HalfVector);
#else
	VtoF_ViewDirection = vec3(newModelPosition.xyz); //vec3(0,0,1);

#endif
    
    VtoF_Normal = newNormal;
	VtoF_Ambient = INPUT_AmbientColour;
	
	 
//    VtoF_TextureCoordCentered = ATTRIB_TextureUV * 2.0 - 1.0;
    VtoF_TextureCoordCentered = ATTRIB_TextureUV / 2.0 + 0.5;
//    VtoF_TextureCoord.x = VtoF_TextureCoord.x * (512.0/512.0);		// Texture Aspect ratio correct
    VtoF_TextureCoord = ATTRIB_TextureUV;
    
    VtoF_Time = 1.0 - fract(0.25 * INPUT_Time);		// Scale and clip our texture motion offset
    
    VtoF_Colour = INPUT_DiffuseColour * ATTRIB_Colour;
   
#if (defined TEXTURING_1_SRCA_1MINUSSRCA) || (defined TEXTURING_1_1_SRCA) || (defined TEXTURING_1_CROSSFADE)
	 VtoF_SecondaryTextureCoord = ATTRIB_SecondaryTextureUV;
	 VtoF_SecondaryTextureCoord.x -= VtoF_Time;
#endif 
    
    gl_Position = newPosition;
}
