#version 100
#extension GL_OES_EGL_image_external : require

precision mediump float;

varying vec2 vTexCoord;

#if defined (EXTERNAL_OES_VIDEO_TEXTURE)
uniform samplerExternalOES sVideoTexture;
#elif defined (TEXTURE_2D_VIDEO_TEXTURE)
uniform sampler2D sVideoTexture;
#endif

uniform float uGammaVal;

void main() {
    vec4 videoSample = texture2D(sVideoTexture, vTexCoord);
    vec3 rgbFactor = pow(videoSample.rgb, vec3(uGammaVal));
    gl_FragColor = vec4(rgbFactor, videoSample.a);
}
