
uniform sampler2D u_texture0; 

precision mediump float;

uniform int u_Border;
uniform int u_Mode;
uniform vec4 u_ColorBegin;
uniform vec4 u_ColorEnd;
uniform vec2 u_GradientCenter;
uniform vec2 u_GradientDirection;
uniform float u_GradientLength;
uniform float u_Opacity;
uniform vec2 u_SamplingOffset;

varying vec2 v_texCoords;

void main(void)
{
    vec4 v4Src = texture2D(u_texture0, v_texCoords - u_SamplingOffset);
    if(u_Mode == 1) // Border
    {
        float fRatio = clamp(dot((v_texCoords - u_GradientCenter), u_GradientDirection) + 0.5, 0.0, 1.0);
        vec4 v4ColorBorder = mix(u_ColorBegin, u_ColorEnd, fRatio);
        float fBorderVal = 1.0 - v4Src.r;
        fBorderVal = fBorderVal * fBorderVal;
        fBorderVal = 1.0 - fBorderVal * fBorderVal;

        gl_FragColor = vec4(v4ColorBorder.rgb, v4ColorBorder.a * fBorderVal * u_Opacity);
    }
    else if(u_Mode == 2) // Shadow
    {
        gl_FragColor = vec4(u_ColorBegin.rgb, v4Src.a * u_ColorBegin.a * u_Opacity);
    }
    else // PiP content
        gl_FragColor = vec4(v4Src.rgb, v4Src.a * u_Opacity);
}