#extension GL_OES_EGL_image_external : require
precision highp float;

uniform sampler2D u_texture0;
uniform sampler2D u_texture1;

uniform float fProgress;
uniform int u_TxIndex;
uniform vec2 u_AspectRatio;
uniform vec2 u_Center;
uniform float u_Inverse;

uniform int u_SampleCount;
uniform vec2 u_Distance[50];

varying vec2 v_texCoords;

void main(){

    vec2 v2RelatedTxCoord = (v_texCoords - u_Center) * u_AspectRatio;
    float fWeight = length(v2RelatedTxCoord) * u_Inverse;
    vec2 v2Direction = normalize(v2RelatedTxCoord);

    vec2 v2TxCoordOffset;
    vec4 v4Result = vec4(0.0);

    if(u_TxIndex == 0)
    {
        for(int index = 0 ; index < u_SampleCount ; ++index)
        {
            v2TxCoordOffset = v2RelatedTxCoord + v2Direction * u_Distance[index].x * fWeight;
            v4Result += texture2D(u_texture0, v2TxCoordOffset / u_AspectRatio + u_Center) * u_Distance[index].y;
        }
    }
    else
    {
        for(int index = 0 ; index < u_SampleCount ; ++index)
        {
            v2TxCoordOffset = v2RelatedTxCoord + v2Direction * u_Distance[index].x * fWeight;
            v4Result += texture2D(u_texture1, v2TxCoordOffset / u_AspectRatio + u_Center) * u_Distance[index].y;
        }
    }

    gl_FragColor = v4Result;
}