// ax+by+c = 0 line equation. lineCoeff = vec3(a,b,c);
uniform vec3 lineCoeff;
uniform float smoothFactor;

// Trasnform the distance to a mask value applying a smoothFactor
float toMaskValue(float dist) {
    // Avoid divide by zero
    float s = smoothFactor + 0.000001;
    return clamp(-dist / s, -0.5, 0.5) + 0.5;
}

float getMask(vec2 uv) {
    float dist = lineCoeff.x * uv.x + lineCoeff.y * uv.y + lineCoeff.z;
    return toMaskValue(dist);
}
