uniform vec2 center;
uniform vec2 radius;
uniform float smoothFactor;

float pow2(float value) {
    return value * value;
}

// Trasnform the distance to a mask value applying a smoothFactor
float toMaskValue(float dist) {
    // Avoid divide by zero
    float s = smoothFactor + 0.000001;
    return clamp(-dist / s, -0.5, 0.5) + 0.5;
}

float getMask(vec2 uv) {
    float r1 = pow2(radius.x);
    float r2 = pow2(radius.y);
    float dist = pow2(uv.x - center.x) / r1 + pow2(uv.y - center.y) / r2 - 1.;

    return toMaskValue(dist);
}
