uniform float strength;
uniform float kernel[25];

// takes the color from the source image at a position shifted by x and y
vec3 shiftedColor(vec2 uv, float x, float y) {
    vec2 shiftedPos = clamp(uv + vec2(x, y), 0., 1.);
    return getFromColor(shiftedPos).rgb;
}

vec3 applyKernel5(vec2 uv, float kernel[25]) {
    vec2 pixelOffset = uv / gl_FragCoord.xy;
    float offX = pixelOffset.x;
    float offY = pixelOffset.y;

    return
        shiftedColor(uv, -offX * 2., offY * 2.) * kernel[0] +
        shiftedColor(uv, -offX, offY * 2.) * kernel[1] +
        shiftedColor(uv, 0.0, offY * 2.) * kernel[2] +
        shiftedColor(uv, offX, offY * 2.) * kernel[3] +
        shiftedColor(uv, offX * 2., offY * 2.) * kernel[4] +

        shiftedColor(uv, -offX * 2., offY) * kernel[5] +
        shiftedColor(uv, -offX, offY) * kernel[6] +
        shiftedColor(uv, 0.0, offY) * kernel[7] +
        shiftedColor(uv, offX, offY) * kernel[8] +
        shiftedColor(uv, offX * 2., offY) * kernel[9] +

        shiftedColor(uv, -offX * 2., 0.0) * kernel[10] +
        shiftedColor(uv, -offX, 0.0) * kernel[11] +
        shiftedColor(uv, 0.0, 0.0) * kernel[12] +
        shiftedColor(uv, offX, 0.0) * kernel[13] +
        shiftedColor(uv, offX * 2., 0.0) * kernel[14] +

        shiftedColor(uv, -offX * 2., -offY) * kernel[15] +
        shiftedColor(uv, -offX, -offY) * kernel[16] +
        shiftedColor(uv, 0.0, -offX) * kernel[17] +
        shiftedColor(uv, offX, -offX) * kernel[18] +
        shiftedColor(uv, offX * 2., -offX) * kernel[19] +

        shiftedColor(uv, -offX * 2., -offY * 2.) * kernel[20] +
        shiftedColor(uv, -offX, -offY * 2.) * kernel[21] +
        shiftedColor(uv, 0.0, -offY * 2.) * kernel[22] +
        shiftedColor(uv, offX, -offY * 2.) * kernel[23] +
        shiftedColor(uv, offX * 2., -offY * 2.) * kernel[24];
}

vec4 process(vec2 uv) {
    vec3 f = applyKernel5(uv, kernel);

    vec4 originalColor = getFromColor(uv);
    vec4 outputColor = vec4(f.rgb, originalColor.a);
    return mix(originalColor, outputColor, strength);
}
