// Based on Vintage01 metal kernel from Splice iOS

vec2 curve(vec2 uv) {
    uv = (uv - 0.5) * 2.0;
    uv *= 1.1;
    uv.x *= 1.0 + pow((abs(uv.y) / 5.0), 2.0);
    uv.y *= 1.0 + pow((abs(uv.x) / 4.0), 2.0);
    uv = (uv / 2.0) + 0.5;
    uv = uv * 0.92 + 0.04;
    return uv;
}

vec4 processEffect(vec2 uv) {
    // TODO: Remove hardcoded resolution value. Metal has access to the dimensions but OpenGL does
    // not. Could also be replaced with a uniform per discussion with FRAT.
    // Original metal code below
    // vec2 resolution = src.size();
    vec2 resolution = vec2(800, 600);
    vec2 q = uv;
    vec2 coordinate = resolution * q;
    vec2 cuv = q;
    cuv = curve(cuv);

    vec3 col;
    float x = sin(0.3 * time + cuv.y * 21.0) * sin(0.7 * time + cuv.y * 29.0) * sin(0.3 + 0.33 * time + cuv.y * 31.0) * 0.0017;

    col.r = getFromColor(vec2(x + cuv.x + 0.001, cuv.y + 0.001)).x + 0.05;
    col.g = getFromColor(vec2(x + cuv.x + 0.000, cuv.y - 0.002)).y + 0.05;
    col.b = getFromColor(vec2(x + cuv.x - 0.002, cuv.y + 0.000)).z + 0.05;

    col.r += 0.08 * getFromColor(0.75 * vec2(x + 0.025, -0.027) + vec2(cuv.x + 0.001, cuv.y + 0.001)).x;
    col.g += 0.05 * getFromColor(0.75 * vec2(x + -0.022, -0.02) + vec2(cuv.x + 0.000, cuv.y - 0.002)).y;
    col.b += 0.08 * getFromColor(0.75 * vec2(x + -0.02, -0.018) + vec2(cuv.x - 0.002, cuv.y + 0.000)).z;

    col = clamp(col * 0.6 + 0.4 * col * col * 1.0, 0.0, 1.0);

    float vig = (0.0 + 1.0 * 16.0 * cuv.x * cuv.y * (1.0 - cuv.x) * (1.0 - cuv.y));
    col *= vec3(pow(vig, 0.3));

    col *= vec3(0.95, 1.05, 0.95);
    col *= 2.8;

    float scans = clamp(0.35 + 0.35 * sin(3.5 * time + cuv.y * resolution.y * 1.5), 0.0, 1.0);

    float s = pow(scans, 1.7);
    col = col * vec3(0.4 + 0.7 * s);

    col *= 1.0 + 0.01 * sin(110.0 * time);
    if (cuv.x < 0.0 || cuv.x > 1.0)
        col *= 0.0;
    if (cuv.y < 0.0 || cuv.y > 1.0)
        col *= 0.0;

    col *= 1.0 - 0.65 * vec3(clamp((mod(coordinate.x, 2.0) - 1.0) * 2.0, 0.0, 1.0));

    //float comp = smoothstep(0.1, 0.9, sin(time));
    // Remove the next line to stop cross-fade between original and postprocess
    //  col = mix( col, oricol, comp );
    return vec4(col, 1.0);
}
