precision highp float;
/** The main sampler of the image. */
uniform sampler2D textureSampler;
/** The pair of texture corrdinates to be used to sample the top-left pixels. */
varying vec2 topLeftTextureCoordinate;
/** The pair of texture corrdinates to be used to sample the top-right pixels. */
varying vec2 topRightTextureCoordinate;
/** The pair of texture corrdinates to be used to sample the bottom-left pixels. */
varying vec2 bottomLeftTextureCoordinate;
/** The pair of texture corrdinates to be used to sample the bottom-left pixels. */
varying vec2 bottomRightTextureCoordinate;

void main() {
    vec4 color = texture2D(textureSampler, topLeftTextureCoordinate);
    color += texture2D(textureSampler, topRightTextureCoordinate);
    color += texture2D(textureSampler, bottomLeftTextureCoordinate);
    color += texture2D(textureSampler, bottomRightTextureCoordinate);
    gl_FragColor = color / 4.;
}
