precision highp float;
/** The varying interpolating for the texture coordinates. */
varying vec2 texCoordinate;
/** Samplers to linearly combine. */
uniform sampler2D sampler1;
uniform sampler2D sampler2;
uniform sampler2D sampler3;
uniform sampler2D sampler4;

void main() {
    /*
     * The following hardcoded coefficients are producing a 60 pixels radius blur when applied
     * to textures downscaled with the BlurRotate by factors of 4, 8, 16 and 32.
     */
    vec4 color = texture2D(sampler1, texCoordinate) * 0.03540662;
    color += (texture2D(sampler2, texCoordinate) * 0.22124398);
    color += (texture2D(sampler3, texCoordinate) * 0.40708134);
    color += (texture2D(sampler4, texCoordinate) * 0.3362681);
    gl_FragColor = color;
}
