uniform vec2 center;
uniform float radius;
uniform float angle;

vec4 process(vec2 uv) {
    highp vec2 textureCoordinateToUse = uv;
    highp float dist = distance(center, uv);

    if (dist < radius) {
        textureCoordinateToUse -= center;
        highp float percent = (radius - dist) / radius;
        highp float theta = percent * percent * angle * 8.0;
        highp float s = sin(theta);
        highp float c = cos(theta);
        textureCoordinateToUse = vec2(dot(textureCoordinateToUse, vec2(c, -s)),
            dot(textureCoordinateToUse, vec2(s, c)));
        textureCoordinateToUse += center;
    }
    return getFromColor(textureCoordinateToUse);
}
