uniform float contrast;

// 'contrast' must be a float greater than 0.
// The returned matrix, when multiplied with a color vector, applies the formula:
// newColor = ((color - 0.5f) * contrast) + 0.5f;
// TODO: define the matrix in the vertex shader for better performances?
mat4 contrastMatrix(float contrastValue) {
    float t = (1.0 - contrastValue) / 2.0;

    return mat4(contrastValue, 0, 0, 0,
        0, contrastValue, 0, 0,
        0, 0, contrastValue, 0,
        t, t, t, 1);
}

vec4 processColor(vec4 color) {
    return contrastMatrix(contrast) * color;
}
