// Based on Chroma01 metal kernel from Splice iOS. Included as a filter rather than effect because
// it is independent of time

// note: from https://www.shadertoy.com/view/MlSXR3
vec2 brownConradyDistortion(vec2 uv, float scalar) {
    uv = (uv - 0.5) * 2.0;

    // positive values of K1 give barrel distortion, negative give pincushion
    float barrelDistortion1 = -0.02 * scalar; // K1 in text books
    float barrelDistortion2 = 0.0 * scalar; // K2 in text books

    float r2 = dot(uv, uv);
    uv *= 1.0 + barrelDistortion1 * r2 + barrelDistortion2 * r2 * r2;

    // tangential distortion (due to off center lens elements)
    // is not modeled in this function, but if it was, the terms would go here
    //    return uv * 0.5 + 0.5;
    return (uv / 2.0) + 0.5;
}

vec4 process(vec2 uv) {
    float maxDistort = 4.0;
    float scalar = 1.0 * maxDistort;
    vec4 colourScalar = vec4(700.0, 560.0, 490.0, 1.0); // Based on the true wavelengths of red, green, blue light.
    colourScalar /= max(max(colourScalar.x, colourScalar.y), colourScalar.z);
    colourScalar *= 2.0;

    colourScalar *= scalar;

    const float numTaps = 2.0;

    vec4 fragColor = vec4(0.0, 0.0, 0.0, 1.0);

    for (float tap = 0.0; tap < numTaps; tap += 1.0) {
        fragColor.r += getFromColor(brownConradyDistortion(uv, colourScalar.r)).r;
        fragColor.g += getFromColor(brownConradyDistortion(uv, colourScalar.g)).g;
        fragColor.b += getFromColor(brownConradyDistortion(uv, colourScalar.b)).b;

        colourScalar *= 0.99;
    }

    fragColor /= numTaps;

    fragColor.a = 1.0;

    return fragColor;
}
