// Based on Chroma04 metal kernel from Splice iOS

vec4 processEffect(vec2 uv) {
    float separation = 0.01;
    float sinWave = sin(time) * separation;
    float cosWave = cos(time) * separation;

    vec2 clockwise = vec2(sinWave, cosWave);
    vec2 counterclockwise = vec2(-sinWave, cosWave);

    vec2 offsetRed = clockwise;
    vec2 offsetGreen = counterclockwise;
    vec2 offsetBlue = vec2(1, 1) * cosWave;

    float red = (getFromColor(uv - offsetRed)).r;
    float green = (getFromColor(uv - offsetGreen)).g;
    float blue = (getFromColor(uv - offsetBlue)).b;

    return vec4(red, green, blue, 1.0);
}
