/** The position of the vertex in the 2D OpenGL vertex positioning space. */
attribute vec2 vertexPosition;
/** The texture coordinate of the vertex in the 2D OpenGL texture sampling space. */
attribute vec2 textureCoordinate;
/** The 3x3 transform matrix to apply to the [vertexPosition]. */
uniform mat3 transformMatrix;
/**
 * The 4x4 transform matrix to apply to the [textureCoordinate].
 * Note: only the st components of the resulting transform are considered.
 */
uniform mat4 textureTransformMatrix;
/**
 * A 3x3 transform matrix to apply to the [textureCoordinate] that is used for masking.
 */
uniform mat3 maskTransformMatrix;
/** Output texture coordinate to be used in the fragment shader. */
varying vec2 texCoordinate;
/** Output mask coordinate to be used in the fragment shader. */
varying vec2 maskCoordinate;

void main() {
    gl_Position = vec4((transformMatrix * vec3(vertexPosition, 1.)).xy, 0., 1.);
    texCoordinate = (textureTransformMatrix * vec4(textureCoordinate, 0., 1.)).xy;
    maskCoordinate = (maskTransformMatrix * vec3(textureCoordinate, 1.)).xy;
}
