/** The position of the vertex in the 2D OpenGL vertex positioning space. */
attribute vec2 vertexPosition;
/** The texture coordinate of the vertex in the 2D OpenGL texture sampling space. */
attribute vec2 textureCoordinate;
/** The pair of texture coordinates to be used to sample the top-left pixels. */
varying vec2 topLeftTextureCoordinate;
/** The pair of texture coordinates to be used to sample the top-right pixels. */
varying vec2 topRightTextureCoordinate;
/** The pair of texture coordinates to be used to sample the bottom-left pixels. */
varying vec2 bottomLeftTextureCoordinate;
/** The pair of texture coordinates to be used to sample the bottom-left pixels. */
varying vec2 bottomRightTextureCoordinate;
/** The size of the output image. */
uniform vec2 outputSize;
/** The 3x3 transform matrix to apply to the [vertexPosition]. */
uniform mat3 transformMatrix;

/** The magic numbers used in this shader are taken from Meishe. */
#define ROTATION_COEFFICIENT 0.36000001430511474609375
#define RADIUS 1.875

void main() {
    gl_Position = vec4((transformMatrix * vec3(vertexPosition, 1.)).xy, 0., 1.);
    vec2 pixelOffset = RADIUS / outputSize;
    float offsetX = pixelOffset.x;
    float offsetY = pixelOffset.y;

    topRightTextureCoordinate = vec2(
        textureCoordinate.x + offsetX,
        textureCoordinate.y + (offsetY * ROTATION_COEFFICIENT)
    );
    bottomRightTextureCoordinate = vec2(
        textureCoordinate.x + (offsetX * ROTATION_COEFFICIENT),
        textureCoordinate.y - offsetY
    );
    topLeftTextureCoordinate = vec2(
        textureCoordinate.x - (offsetX * ROTATION_COEFFICIENT),
        textureCoordinate.y + offsetY
    );
    bottomLeftTextureCoordinate = vec2(
        textureCoordinate.x - offsetX,
        textureCoordinate.y - (offsetY * ROTATION_COEFFICIENT)
    );
}
