// Based on https://www.shadertoy.com/view/4sc3D7#

// Other background resources
// https://www.shadertoy.com/view/lsSXW1
// https://tannerhelland.com/2012/09/18/convert-temperature-rgb-algorithm-code.html

uniform vec3 temperatureColor;
uniform float temperatureStrength;
uniform float luminancePreservationFactor;

vec4 processColor(vec4 color) {
    // Apply temperature adjustment
    vec3 fullTemperaturedColor = color.rgb * temperatureColor;
    vec3 outColor = mix(color.rgb, fullTemperaturedColor, temperatureStrength);
    // Luminance perservation
    vec3 lumReference = vec3(0.2126, 0.7152, 0.0722);
    float originalLumCoeff = dot(outColor, lumReference);
    float outputLumCoeff = dot(color.rgb, lumReference);
    float lumMultiplier = outputLumCoeff / max(originalLumCoeff, 1e-5);
    outColor *= mix(1.0, lumMultiplier, luminancePreservationFactor);

    return vec4(outColor.rgb, color.a);
}
