uniform vec2 center;
uniform float radius;
uniform float aspectRatio;
uniform float refractiveIndex;

vec4 process(vec2 uv) {
    highp vec2 textureCoordinateToUse = vec2(
        uv.x, (uv.y * aspectRatio + 0.5 - 0.5 * aspectRatio)
    );

    highp float distanceFromCenter = distance(center, textureCoordinateToUse);
    lowp float checkForPresenceWithinSphere = step(distanceFromCenter, radius);
    distanceFromCenter = distanceFromCenter / radius;

    highp float normalizedDepth =
        radius * sqrt(1.0 - distanceFromCenter * distanceFromCenter);
    highp vec3 sphereNormal =
        normalize(vec3(textureCoordinateToUse - center, normalizedDepth));
    highp vec3 refractedVector =
        refract(vec3(0.0, 0.0, -1.0), sphereNormal, refractiveIndex);
    return getFromColor((refractedVector.xy + 1.0) * 0.5) * checkForPresenceWithinSphere;
}
