uniform float strength;
uniform mat3 kernel3;

// takes the color from the source image at a position shifted by x and y
vec3 shiftedColor(vec2 uv, float x, float y) {
    vec2 shiftedPos = clamp(uv + vec2(x, y), 0., 1.);
    return getFromColor(shiftedPos).rgb;
}

vec3 applyKernel3(vec2 uv, mat3 kernel3) {
    vec2 pixelOffset = uv / gl_FragCoord.xy;
    float offX = pixelOffset.x;
    float offY = pixelOffset.y;
    return
        shiftedColor(uv, -offX, offY) * kernel3[0][0] + // top-left
        shiftedColor(uv, 0.0, offY) * kernel3[0][1] + // top-center
        shiftedColor(uv, offX, offY) * kernel3[0][2] + // top-right
        shiftedColor(uv, -offX, 0.0) * kernel3[1][0] + // center-left
        shiftedColor(uv, 0.0, 0.0) * kernel3[1][1] + // center-center
        shiftedColor(uv, offX, 0.0) * kernel3[1][2] + // center-right
        shiftedColor(uv, -offX, -offY) * kernel3[2][0] + // bottom-left
        shiftedColor(uv, 0.0, -offY) * kernel3[2][1] + // bottom-center
        shiftedColor(uv, offX, -offX) * kernel3[2][2]; // bottom-right
}

vec4 process(vec2 uv) {
    vec3 f = applyKernel3(uv, kernel3);

    vec4 originalColor = getFromColor(uv);
    vec4 outputColor = vec4(f.rgb, originalColor.a);
    return mix(originalColor, outputColor, strength);
}
