// Based on Glitch02 metal kernel from Splice iOS

float rand(float n) { return fract(sin(n) * 43758.5453123); }

float rand(vec2 co, float seed) {
    return fract(sin(dot(co, vec2(12.9898, 78.233) + fract(seed))) * 43758.5453);
}

vec3 get_rgb_noise(vec2 uv, float seed) {
    return vec3(
        rand(uv, seed),
        rand(uv, seed + 0.33),
        rand(uv, seed + 0.66)
    );
}

float noise(float p) {
    float fl = floor(p);
    float fc = fract(p);
    return mix(rand(fl), rand(fl + 1.0), fc);
}

float blockyNoise(vec2 uv, float threshold, float scale, float seed, float time) {
    float scroll = floor(time + sin(11.0 * time) + sin(time)) * 0.77;
    vec2 noiseUV = fract(uv.yy / scale + scroll);
    float noise2 = getFromColor(noiseUV).r;

    float id = floor(noise2 * 20.0);
    id = noise(id + seed) - 0.5;

    if (abs(id) > threshold)
        id = 0.0;

    return id;
}

vec4 processEffect(vec2 uv) {
    float rgbIntensity = 0.1 + 0.1 * sin(time * 3.7);
    float displaceIntensity = 0.2 + 0.3 * pow(sin(time * 1.2), 5.0);
    float interlaceIntensity = 0.01;
    float dropoutIntensity = 0.1;

    // TODO Remove hardcoded size value. Refer to discussion in PR 172 (feat: porting vintage)
    // Original metal code included below for reference
    // float2 size = src0.size();
    vec2 size = vec2(800, 600);
    vec2 coordinate = uv * size;

    float displace = blockyNoise(uv + vec2(uv.y, 0.0), displaceIntensity, 25.0, 66.6, time);
    displace *= blockyNoise(uv.yx + vec2(0.0, uv.x), displaceIntensity, 111.0, 13.7, time);

    uv.x += displace;

    vec2 offs = 0.1 * vec2(blockyNoise(uv.xy + vec2(uv.y, 0.0), rgbIntensity, 65.0, 341.0, time), 0.0);

    float colr = getFromColor(uv - offs).r;
    float colg = getFromColor(uv).g;
    float colb = getFromColor(uv + offs).b;

    float line = fract(coordinate.y / 3.0);
    vec3 mask = vec3(3.0, 0.0, 0.0);
    if (line > 0.333)
        mask = vec3(0.0, 3.0, 0.0);
    if (line > 0.666)
        mask = vec3(0.0, 0.0, 3.0);

    mask = vec3(min(mask.x, 1.0), min(mask.y, 1.0), min(mask.z, 1.0));

    float maskNoise = blockyNoise(uv, interlaceIntensity, 90.0, time, time) * max(displace, offs.x);

    maskNoise = 1.0 - maskNoise;
    if (maskNoise == 1.0)
        mask = vec3(1.0);

    float dropout = blockyNoise(uv, dropoutIntensity, 11.0, time, time) * blockyNoise(uv.yx, dropoutIntensity, 90.0, time, time);
    mask *= (1.0 - 5.0 * dropout);

    vec3 color = vec3(colr, colg, colb);

    return vec4(mask * color, 1.0);
}
