// Based on Glitch01 metal kernel from Splice iOS

float rand(vec2 co, float seed) {
    return fract(sin(dot(co, vec2(12.9898, 78.233) + fract(seed))) * 43758.5453);
}

vec3 get_rgb_noise(vec2 uv, float seed) {
    return vec3(
        rand(uv, seed),
        rand(uv, seed + 0.33),
        rand(uv, seed + 0.66)
    );
}

vec4 processEffect(vec2 uv) {
    // TODO Remove hardcoded size value. Refer to discussion in PR 172 (feat: porting vintage)
    // Original metal code included below for reference
    // vec2 size = src0.size();
    vec2 size = vec2(800, 600);
    vec2 coordinate = vec2(uv * size);
    float blockSize = size.x / 8.0;
    // assign this coordinate to a specific block made of 16 pixels
    vec2 block = floor(coordinate.xy / vec2(blockSize));
    vec2 uv_noise = block / vec2(blockSize);
    uv_noise += floor(vec2(time) * vec2(1234.0, 3543.0)) / vec2(blockSize);
    uv_noise = fract(uv_noise);

    // increase the last number to have more blocks
    float block_thresh = pow(fract(time * 1236.0453), 2.0) * 0.1;
    // increase the last number to have more lines
    float line_thresh = pow(fract(time * 2236.0453), 3.0) * 0.3;

    vec2 uv_r = uv, uv_g = uv, uv_b = uv;

    // glitch some blocks and lines
    if (get_rgb_noise(uv_noise, time).r < block_thresh || get_rgb_noise(vec2(uv_noise.y, 0.0), time).g < line_thresh) {
        vec2 dist = (uv_noise - 0.5) * 0.3;
        uv_r += dist * 0.1;
        uv_g += dist * 0.2;
        uv_b += dist * 0.125;
    }

    vec4 color = vec4(1);

    color.r = getFromColor(uv_r).r;
    color.g = getFromColor(uv_g).g;
    color.b = getFromColor(uv_b).b;

    // loose luma for some blocks
    if (get_rgb_noise(uv_noise, time).g < block_thresh)
        color.rgb = color.ggg;

    // discolor block lines
    if (get_rgb_noise(vec2(uv_noise.y, 0.0), time).b * 3.5 < line_thresh)
        color.rgb = vec3(0.0, dot(color.rgb, vec3(1.0)), 0.0);

    // interleave lines in some blocks
    if (get_rgb_noise(uv_noise, time).g * 1.5 < block_thresh ||
            get_rgb_noise(vec2(uv_noise.y, 0.0), time).g * 2.5 < line_thresh) {
        float line = fract(coordinate.y / 12.0);
        vec3 mask = vec3(3.0, 0.0, 0.0);
        if (line > 0.333)
            mask = vec3(0.0, 3.0, 0.0);
        if (line > 0.666)
            mask = vec3(0.0, 0.0, 3.0);

        color.xyz *= mask;
        color = vec4(min(color.x, 1.0), min(color.y, 1.0), min(color.z, 1.0), 1.0);
    }

    return color;
}
