// Based on Chroma02 metal kernel from Splice iOS

vec4 processEffect(vec2 uv) {
    float amount = 0.0;
    amount = (1.0 + sin(time * 6.0)) * 0.8;
    amount *= (1.0 + sin(time * 16.0)) * 0.8;
    amount *= (1.0 + sin(time * 19.0)) * 0.8;
    amount *= (1.0 + sin(time * 27.0)) * 0.8;
    amount = pow(amount, 3.0);
    amount *= 0.05;

    vec4 color;
    color.r = getFromColor(vec2(uv.x + amount, uv.y)).r;
    color.g = getFromColor(uv).g;
    color.b = getFromColor(vec2(uv.x - amount, uv.y)).b;

    color *= (1.0 - amount * 0.5);

    color.a = 1.0;

    return color;
}
