/** The position of the vertex in the 2D OpenGL vertex positioning space. */
attribute vec2 vertexPosition;
/** The texture coordinate of the vertex in the 2D OpenGL texture sampling space. */
attribute vec2 textureCoordinate;
/** Output texture coordinate to be used in the fragment shader. */
varying vec2 texCoordinate;
/** The 3x3 transform matrix to apply to the [vertexPosition]. */
uniform mat3 transformMatrix;

void main() {
    gl_Position = vec4((transformMatrix * vec3(vertexPosition, 1.)).xy, 0., 1.);
    texCoordinate = textureCoordinate;
}
