// Generic filter for applying a Color Filter from a LUT

// Based on glsl-lut repository
//      GitHub: https://github.com/mattdesl/glsl-lut/blob/master/README.md
//      Sample Website: https://www.npmjs.com/package/glsl-lut
//      Example LUT Sampling: https://github.com/mattdesl/glsl-lut/blob/master/index.glsl
//
// And this article
//      Article:
//          http://liovch.blogspot.com/2012/07/add-instagram-like-effects-to-your-ios.html
//      Example LUT Sampling:
//          https://github.com/liovch/GPUImage/blob/master/framework/Source/GPUImageLookupFilter.m
//

uniform float intensity;

vec4 getLUTColor(vec2 uv) {
    return getColor1(uv);
}

vec4 processColor(vec4 frameColor) {
    float blueColor = frameColor.b * 63.0;

    vec2 quad1;
    quad1.y = floor(floor(blueColor) / 8.0);
    quad1.x = floor(blueColor) - (quad1.y * 8.0);

    vec2 quad2;
    quad2.y = floor(ceil(blueColor) / 8.0);
    quad2.x = ceil(blueColor) - (quad2.y * 8.0);

    vec2 texPos1;
    texPos1.x = (quad1.x * 0.125) + 0.5 / 512.0 + ((0.125 - 1.0 / 512.0) * frameColor.r);
    texPos1.y = (quad1.y * 0.125) + 0.5 / 512.0 + ((0.125 - 1.0 / 512.0) * frameColor.g);

    vec2 texPos2;
    texPos2.x = (quad2.x * 0.125) + 0.5 / 512.0 + ((0.125 - 1.0 / 512.0) * frameColor.r);
    texPos2.y = (quad2.y * 0.125) + 0.5 / 512.0 + ((0.125 - 1.0 / 512.0) * frameColor.g);

    vec4 newColor1 = getLUTColor(texPos1);
    vec4 newColor2 = getLUTColor(texPos2);

    vec4 newColor = mix(newColor1, newColor2, fract(blueColor));

    vec4 finalColor = mix(frameColor, newColor, intensity);
    return finalColor;
}
