// Based on Chroma03 metal kernel from SpliceiOS. Included as a filter rather than effect because
// it is independent of time

float bx2(float x) {
    return x * 2.0 - 1.0;
}

vec4 process(vec2 uv) {
    float redShift = 0.16;
    float greenShift = 0.08;
    float blueShift = 0.023;
    float aberrationStrength = 1.0;

    float uvXOffset = bx2(uv.x);
    float customXOffset = 0.0;
    float uvXFromCenter = uvXOffset - customXOffset;
    float finalUVX = uvXFromCenter * abs(uvXFromCenter) * aberrationStrength;

    float redChannel = getFromColor(vec2(uv.x - (finalUVX * redShift), uv.y)).r;
    float greenChannel = getFromColor(vec2(uv.x - (finalUVX * greenShift), uv.y)).g;
    float blueChannel = getFromColor(vec2(uv.x - (finalUVX * blueShift), uv.y)).b;

    return vec4(redChannel, greenChannel, blueChannel, 1.0);
}
