from EvePythonKit import Log as Log
try:
    import importlib
    import json
    def InvokePythonStaticMethod(moduleName, methodName, params):
        ret = {}
        errorMsg = ""
        try:
            module = importlib.import_module(moduleName)
            targetMethod = get_method(module, methodName)
            ret = targetMethod(params)
        except Exception as exc:
            import traceback
            Log.e(str(exc))
            errorMsg = traceback.format_exc()
            Log.e(errorMsg)
        return json.dumps([ret, errorMsg])

    def InvokePythonClassMethod(moduleName, className, methodName, params):
        ret = {}
        errorMsg = ""
        try:
            module = importlib.import_module(moduleName)
            targetClass = get_class(module, className)
            targetMethod = get_method(targetClass, methodName)
            ret = targetMethod(params)
        except Exception as exc:
            import traceback
            Log.e(str(exc))
            errorMsg = traceback.format_exc()
            Log.e(errorMsg)
        return json.dumps([ret, errorMsg])

    def InvokePythonInstanceMethod(moduleName, className, methodName, params):
        ret = {}
        errorMsg = ""
        try:
            module = importlib.import_module(moduleName)
            targetClass = get_class(module, className)
            targetInstance = targetClass(moduleName)
            targetMethod = get_method(targetInstance, methodName)
            ret = targetMethod(params)
        except Exception as exc:
            import traceback
            Log.e(str(exc))
            errorMsg = traceback.format_exc()
            Log.e(errorMsg)
        return json.dumps([ret, errorMsg])


    def get_class(module, class_name):
        return getattr(module, class_name)


    def get_method(instance, method_name):
        return getattr(instance, method_name)

except Exception as exc:
    Log.e(str(exc))

