import _NativeBridge
import json
from EvePythonKit import Log

get_data_from_provider_identifier = "getDataFromProvider"

class CalculateResult(object):
  def __init__(self, code, result, msg):
        self.code = code
        self.result = result
        self.msg = msg

  def toJSON(self):
        return {
            "code": self.code,
            "result": self.result,
            "msg": self.msg
        }

  @staticmethod
  def parseJSON(dct):
        if isinstance(dct, dict) and "code" in dct:
            # Log.i("process CalculateResult:" + str(dct))
            c = CalculateResult(dct["code"], dct.get('result'), dct['msg'])
            return c
        return dct
  
  def __str__(self):
      return "CalculateResult: code={}, msg={}, result={}".format(self.code, self.msg, self.result)

class NativeBridge(object):
  @staticmethod
  def communicate(identifier, param) -> dict:
    param_str = json.dumps(param)
    json_str = _NativeBridge.communicate(identifier, param_str)
    return json.loads(json_str)

  @staticmethod
  def getDataFromProvider(param) -> dict:
    param_str = json.dumps(param)
    json_str = _NativeBridge.communicate(get_data_from_provider_identifier, param_str)
    return json.loads(json_str)
  
  @staticmethod
  def queryBySql(sqlString: str, tableName = "", taskId = "", inferenceId = "", version ="") -> CalculateResult:
    # json_str = _NativeBridge.queryBySql(sqlString, tableName, taskId, inferenceId, version)
    # return json.loads(json_str, object_hook=CalculateResult.parseJSON)
      retDict = _NativeBridge.queryBySql(sqlString, tableName, taskId, inferenceId, version)
      return CalculateResult.parseJSON(retDict)
  
  @staticmethod
  def system_log(level: int, tag: str, msg: str):
    _NativeBridge.system_log(level, tag, msg)

  @staticmethod
  def kNNPredict(input:dict, modelPath: str, modelType: str, needCache: bool):
    return _NativeBridge.kNNPredict(input, modelPath, modelType, needCache)
  
  @staticmethod
  def eveKvGet(key: str, subKey: str) -> object:
    json_str = _NativeBridge.eveKvGet(key, subKey)
    return json_str
    