from EvePythonKit.NativeBridge import *

getKswitchLongFuncKey = "getKswitchLong"
getKswitchStringFuncKey = "getKswitchString"
getKswitchFloatFuncKey = "getKswitchFloat"
getKswitchBoolFuncKey = "getKswitchBool"
bridgeFuncKey = "getDataFromProvider"

def getLong(key: str, default: int):
  param = {
    "schema": getKswitchLongFuncKey,
    "params": [key, default]
  }
  ret = NativeBridge.communicate(bridgeFuncKey, param)
  if ret.get("code") == 0:
    return ret["data"]
  else:
    return default

def getString(key: str, default: str):
  param = {
    "schema": getKswitchStringFuncKey,
    "params": [key, default]
  }
  ret = NativeBridge.communicate(bridgeFuncKey, param)
  if ret.get("code") == 0:
    return ret["data"]
  else:
    return default

def getFloat(key: str, default: float):
  param = {
    "schema": getKswitchFloatFuncKey,
    "params": [key, default]
  }
  ret = NativeBridge.communicate(bridgeFuncKey, param)
  if ret.get("code") == 0:
    return ret["data"]
  else:
    return default

def getBool(key: str, default: bool):
  param = {
    "schema": getKswitchBoolFuncKey,
    "params": [key, default]
  }
  ret = NativeBridge.communicate(bridgeFuncKey, param)
  if ret.get("code") == 0:
    return ret["data"]
  else:
    return default