from EvePythonKit.NativeBridge import NativeBridge, CalculateResult
from EvePythonKit.SqlBuilder import QuerySet, Table
from EvePythonKit.SqlBuilder import Field as F
from EvePythonKit import JobBuilder
from EvePythonKit import Log as Log

common_feature_schema = "getCommonFeatures"
user_feature_schema = "getUserFeatures"

Second = 1000
Minute = Second * 60
Hour = Minute * 60
Day = Hour * 24

class EveTable(object):
  def __init__(self, name, alias=None):
    super().__init__(name, alias)
  
  @staticmethod
  def SHOW():
    return Table("table_ShowEvent")
  
  @staticmethod
  def PAGE():
    return Table("table_PageEvent")
  
  @staticmethod
  def PLAY():
    return Table("table_PlayEvent")

  @staticmethod
  def CLICK():
    return Table("table_ClickEvent")
  
  @staticmethod
  def LIVE():
    return Table("table_LIVE")
  
  @staticmethod
  def APP():
    return Table("table_APP")
  
  @staticmethod
  def TASK():
    return Table("table_TASK")
  
  @staticmethod
  def AFK():
    return Table("table_AFKEvent")

class FeatureCenter(object):
  @staticmethod
  def getCommonFeatures(keys = []):
    param = {
      "schema": common_feature_schema,
      "params": keys
    }
    ret = NativeBridge.getDataFromProvider(param)
    if ret["code"] == 0:
      return ret["data"]
    else:
      return None

  @staticmethod
  def getUserFeatures(keys = []):
    param = {
      "schema": user_feature_schema,
      "params": keys
    }
    ret = NativeBridge.getDataFromProvider(param)
    if ret["code"] == 0:
      return ret["data"]
    else:
      return None
  
  @staticmethod
  def getFeatures(category: str, keys = []):
    param = {
      "schema": "getFeatures",
      "params": [category, keys]
    }
    ret = NativeBridge.getDataFromProvider(param)
    if ret["code"] == 0:
      return ret["data"]
    else:
      return None
    
  @staticmethod
  def getFeature(category: str, key):
    features = FeatureCenter.getFeatures(category, [key])
    if features is not None and key in features:
      return features[key]
    else:
      return None 
  
  @staticmethod
  def getFeedFeature(feedId: str) -> dict:
    ret = NativeBridge.eveKvGet('NASA_FEATURED', feedId)
    return ret
    # if isinstance(ret, str):
    #    return json.loads(ret)
    # else:
    #    Log.e("getFeedFeature feedId: {}, value is not valid {}".format(feedId, ret))
    #    return None
  
  @staticmethod
  def calculate(job: object) -> CalculateResult:

    if isinstance(job, dict):
      sql = JobBuilder.generate_sql_query(job)
      if 'from' in job:
        tableName = job["from"].name
        ret = NativeBridge.queryBySql(sql, tableName)
        # Log.i("call NativeBridge.queryBySql: {} ".format(sql))
        return ret
      else:
        Log.i("call NativeBridge.queryBySql: 'from' can not be empty")
        return None

    elif isinstance(job, QuerySet):
      ret = NativeBridge.queryBySql(job.fullSql, job.tables)
      # Log.i("call NativeBridge.queryBySql: {} ".format(job.fullSql))
      return ret
  
  @staticmethod
  def combinedAndFilters(*filters):
    return {"op": "AND", "filters": list(filters)}

  @staticmethod
  def singleFilter(filter_data):
    return filter_data

  @staticmethod
  def primitive2Value(value):
    return "'{}'".format(value)