import os

class BaseSolution(object):
  def __init__(self) -> None:
    self.filePath = ""

  def run(self, params):
    return self.makeResult({},{})


  def makeResult(self, result :object, upload :str) -> dict:
    return {
      "result": result,
      "upload": {
        "key":"upload",
        "value": upload
      }
    }
  
  def getRootPath(self):
    if len(self.filePath) == 0:
      raise Exception("Please set __file__ to self.filePath first")
    return os.path.abspath(os.path.dirname(self.filePath))
      