from EvePythonKit.FeatureCenter import FeatureCenter
from EvePythonKit.BaseSolution import BaseSolution
# from EvePythonKit.pypika import *

# 运行过程 : 实例化Solution => 调用实例对象的run方法 => 销毁实例对象

class Solution(BaseSolution):
  def __init__(self, name):
    self.name = name

  def run(self, params):
    features = FeatureCenter.getCommonFeatures(
      [
        "c_age",
        "c_network",
        "c_current_timestamp"
      ]
    )
    
    girl = Table("girl")
    sql = Query.from_(girl).select("*").where(
        Criterion.all([girl.id > 10,
                    girl.age > 18,
                    girl.height.isin([155, 156, 157])]))
    return sql