---@class String
String = {}

local loadstring = loadstring or load -- 兼容Lua的不同版本

local string_meta = getmetatable("")
string_meta.__add = function(v1, v2)
    if type(v1) == "string" or type(v2) == "string" then
        return v1 .. v2
    end
    return v1 + v2
end

--- 以Json的格式打印Lua对象
---
--- @eve_version 1.0.0
--- @param o any
--- @return string
function str(o)
    if o == null then
        return "nil"
    end
    local printTarget = nil
    if o._is_list == true or o._is_dict == true then
        printTarget = o._data
    else
        printTarget = o
    end
    return Json:toJsonString(printTarget)
end

---
---返回字符 `s[i]`， `s[i+1]`， ...　，`s[j]` 的内部数字编码。
---
---@eve_version 1.0.0
---@param s  string
---@param i? integer
---@param j? integer
---@return integer
---@return ...
---@nodiscard
function ascii(s, i, j) 
    string.byte(s, i, j)
end

---
---接收零或更多的整数。 返回和参数数量相同长度的字符串。 其中每个字符的内部编码值等于对应的参数值。
---
---@param byte integer
---@param ... integer
---@return string
---@return ...
---@nodiscard
function chr(byte, ...) 
    string.char(byte, ...) 
end

return String
