--- @class Ref

Ref = {}

--- 创建一个Ref对象(将参数中的数据拷贝到C++层,并创建一个该数据的引用返回给lua)
--- 
--- @eve_version 1.0
--- @param data LuaValue Lua数据,可以是nil/boolean/number/string/table以及其嵌套结构
--- @return Ref
function Ref:createRef(data)
    return createRef(data)
end

--- 创建一个底层是Map的Ref对象
---
--- @eve_version 1.0
--- @return Ref
function Ref:createEmptyMapRef()
    return createEmptyMapRef()
end

--- 将Ref底层的 C++数据 输入到Lua虚拟机中,转换成Lua脚本内的[Lua数据]
--- 返回数据可能是:nil/boolean/number/string/table以及其嵌套结构
--- 
--- @eve_version 1.0
--- @param key string
--- @return table 
function Ref:getValue(key)
end

--- 在[底层数据是map或者list的ref(以下简称parentRef)]中获取其[子数据的ref(以下简称childRef)]
--- * 如果parentRef底层数据既不是map也不是list,为不合法输入,会抛出lua异常
--- * 如果parentRef底层为map,那么第二个参数keyOrIndex则应该是map的检索的key
--- * 如果parentRef底层为list,那么第二个参数(必须稳number)则应该是list的index
--- 
--- @eve_version 1.0
--- @param parentRef Ref 底层是map或list的ref
--- @param keyOrIndex number 检索map的key或者检索list的index
--- @return Ref
function Ref:getRef(parentRef, keyOrIndex)
end

--- 当[ref的C++底层数据]是map时,该接口可以用来获取该map中所有的key
--- 
--- @eve_version 1.0
--- @return table 内部包含[Ref的C++底层数据-map]中的所有key
--- @exception 如果[ref的C++底层数据]不是map,则抛出异常
function Ref:getMapKeys()
end

--- 当[ref的C++底层数据]是map或者list时,该接口可以用来获取该map或者list中的元素(对)个数
--- 
--- @eve_version 1.0
--- @return number 代表 map中键值对的个数,或者list中元素的个数
--- @exception  如果[ref的C++底层数据]既不是map也不是list,则抛出异常
function Ref:getSize()
end


--- 当[ref的C++底层数据]是map或者list时,该接口可以用来判断该数据结构内是否为空
--- 
--- @eve_version 1.0
--- @return boolean 
--- @exception 如果[ref的C++底层数据]既不是map也不是list,则抛出异常
function Ref:isEmpty()
end

--- 返回一个Ref的子类型, 子类型如下
---	 LuaValueTypeNil = 0
---  LuaValueTypeNumber = 1
---  LuaValueTypeBoolean = 2
---  LuaValueTypeString = 3
---  LuaValueTypeArray = 4
---  LuaValueTypeMap = 5
---  LuaValueTypeInteger = 8
---  LuaValueTypeData = 9
---  LuaValueTypeFloat = 19
---  LuaValueTypePb = 20
---  LuaValueTypeOthers = -1
--- 
--- @eve_version 1.0
--- @return number ref的C++底层数据的类型
function Ref:getType()
end

--- 当[ref的C++底层数据]list时,该接口可以用来向其中添加数据, 如果[ref的C++底层数据]不是list,则抛出异常
--- @eve_version 1.0
--- @param dataOrRef Ref 添加的内容可以是[lua数据],也可以是其他ref
--- @return nil 
function Ref:put(dataOrRef)
end

--- 当[ref的C++底层数据]为map时,该接口可以用来向其中添加数据
--- @eve_version 1.0
--- @param keyOrIndex string map的key
--- @param dataOrRef table 添加的内容可以是[lua数据],也可以是其他ref
--- @return nil
function Ref:put(keyOrIndex, dataOrRef)
end


--- 当[ref的C++底层数据]为List<Map<*, *>>时,该接口可以用来将所有数据拷贝转化成DataSet
--- 转化过程中，List<Map<*, *>>内会先按照map中不同的feature进行聚合
--- 如果部分ListItem中缺失部分属性，那么会使用defaultValue进行填充
--- 
--- @eve_version 1.0
--- @param defaultValue number 在转化时缺失的值的默认填充值
--- @param blackList table 转化成DataSet时的黑名单,黑名单内的属性会被过滤
--- @param whiteList table 转化成DataSet时的白名单,白名单未空时,则默认全选,非空时,则只转化白名单内的属性
--- @return DataSet
function Ref:makeDataSet(defaultValue, blackList, whiteList)
end

--- 将Ref转化为NDArry
--- 
--- @eve_version 1.0
--- @return NdArray
function Ref:toNdarray()
end

--- 将一个ref内的所有数据输出位json
--- 
--- @eve_version 1.0
--- @return string json字符串
function Ref:toJsonString()
end

return Ref