require 'EveLuaKit.dict'
require 'EveLuaKit.string'

LuaModuleRunner = {}
LuaModuleRunner.moduleCache = Dict:new({})

function LuaModuleRunner:createModule(path)
    local luaModule = self.moduleCache[path]
    if type(luaModule) == "table" then
        return luaModule
    else
        luaModule = dofile(path)
        luaModule:init()
        self.moduleCache[path] = luaModule
        return luaModule
    end
end


function LuaModuleRunner:run(path, entry, param)
    local luaModule = LuaModuleRunner:createModule(path)
    if type(luaModule) == "table" then
        local entryFunc = luaModule[entry]
        return entryFunc(luaModule, param)
    end
end

function RunLuaAsModule(path, entry, param)
    return LuaModuleRunner:run(path, entry, param)
end

function loadEveTaskLuaFiles(paths)
    for index, path in ipairs(paths) do 
        local luaModule = LuaModuleRunner.moduleCache[path]
        if luaModule == nil then
            -- 此时不存在曾经加载过的缓存
            luaModule = dofile(path)
            if type(luaModule) == 'table' then
                -- 该任务为模块化任务
                luaModule:init()
                LuaModuleRunner.moduleCache[path] = luaModule
            else
                -- 非模块化任务
                -- 此时该lua文件已经被eval，无需其他操作
            end
        end
    end
end

function ClearModuleCache(path)
    -- 不指定路径的话就清理所有缓存
    if path == nil then
        LuaModuleRunner.moduleCache = Dict:new({})
        Log_d("清理所有模块缓存")
        return
    end

    -- 清理指定路径的缓存
    local luaModule = LuaModuleRunner.moduleCache[path]
    if type(luaModule) == "table" then
        luaModule:dealloc()
        LuaModuleRunner.moduleCache[path] = nil
        Log_d("清理指定路径模块缓存:"+path)
    end
end

return LuaModuleRunner